<?php
session_start();
include("connection.php");
//error_reporting(0);
if(isset($_SESSION['admin'])){
include('header.php') ?>


            <!-- Page Content Start -->
        <div class="content-page">
            <div class="content">
                <div class="container-fluid">

                    <!-- Page title box -->
                   <div class="page-title-box">
                        <ol class="breadcrumb float-right">
                            <li class="breadcrumb-item"><a href="javascript:void(0);">Dashboard</a></li>
                            <li class="breadcrumb-item"><a href="javascript:void(0);">Trade History</a></li>
                            <li class="breadcrumb-item active">Trade Tables</li>
                        </ol>
                        <h4 class="page-title">Trades</h4>
                    </div>
                    <!-- End page title box -->
                    
                    <div class="row">
                        <div class="col-12">
                            <div class="card-box">
                                <h4 class="header-title">Trade History</h4>
                                <table id="datatable-buttons" class="table table-striped table-bordered dt-responsive nowrap">
                                    <thead>
                                        <tr>
                                            <th>Trade Date</th>
                                            <th>Symbol</th>
                                            <th>Trade Account</th>
                                            <th>Trade Side</th>
                                            <th>Amount</th>
                                            <th>Profit</th>
                                            <th>Status</th>
                                        </tr>
                                    </thead>
                    
                                    <tbody>
                                    <?php  
                                    // Query to fetch trade data
                                    $query_trades = "SELECT demo_trades.id, 
                                                            demo_trades.symbol, 
                                                            demo_trades.account, 
                                                            demo_trades.amount, 
                                                            demo_trades.trade_side, 
                                                            demo_trades.type, 
                                                            demo_trades.profit, 
                                                            demo_trades.image, 
                                                            demo_trades.created_at, 
                                                            users.username 
                                                     FROM demo_trades 
                                                     JOIN users ON demo_trades.user_id = users.id 
                                                     ORDER BY demo_trades.created_at DESC";
                                    
                                    $result = mysqli_query($myConn, $query_trades);
                    
                                    // Loop through the results and display them in the table
                                    while ($row = mysqli_fetch_array($result, MYSQLI_BOTH)) {
                                        $trade_date = $row["created_at"];
                                        $symbol = $row["symbol"];
                                        $trade_side = ucfirst($row["trade_side"]); // e.g., Buy/Sell
                                        $type = $row["type"];
                                        $amount = $row["amount"];
                                        $account = $row["account"];
                                        $profit = $row["profit"];
                                        $image = $row["image"];
                                        $username = $row["username"];
                    
                                        // Determine status based on profit
                                        $status = $profit >= 0 ? "<div class='badge badge-success'>Profit</div>" : "<div class='badge badge-danger'>Loss</div>";
                                        // Determine type text and color
                                        if ($type == 1) {
                                            $type_text = "<span style='color: green; font-weight: bold;'>GAIN</span>";
                                            $profit_text = "<span style='color: green;'>+$" . number_format($profit, 2) . "</span>";
                                        } elseif ($type == 2) {
                                            $type_text = "<span style='color: red; font-weight: bold;'>LOSS</span>";
                                            $profit_text = "<span style='color: red;'>-$" . number_format(abs($profit), 2) . "</span>";
                                        } else {
                                            $type_text = "<span>Unknown</span>";
                                        }
                                        
                                        
                                        if ($trade_side == 1) {
                                            $trade_side = "<span style='color: green; font-weight: bold;'>Buy</span>";
                                        } elseif ($trade_side == 2) {
                                            $trade_side = "<span style='color: red; font-weight: bold;'>SELL</span>";
                                        }
                                    ?>
                                        <tr>
                                            <td><?php echo $trade_date; ?></td>
                                            <td><?php echo $symbol; ?></td>
                                            <td><?php echo $account; ?></td>
                                            <td><?php echo $trade_side; ?></td>
                                            <td>$<?php echo number_format($amount, 2); ?></td>
                                            <td><?php echo $profit_text; ?></td>
                                            <td><?php echo $type_text; ?></td>
                                            
                                        </tr>
                                    <?php } ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                    <!-- end row -->




                </div> <!-- end container-fluid-->
            </div> <!-- end contant-->
        </div>
        <!-- End Page Content-->
     


                <!-- Footer Start -->
                <footer class="footer">
                    <div class="container-fluid">
                        <div class="row">
                            <div class="col-md-12 text-center">
                                  <script>document.write(new Date().getFullYear())</script> ©  <?=$sitename?>
                            </div>
                        </div>
                    </div>
                </footer>
                <!-- end Footer -->

            </div>

            <!-- ============================================================== -->
            <!-- End Page content -->
            <!-- ============================================================== -->


        </div>
        <!-- END wrapper -->

       

        <!-- Right bar overlay-->
        <div class="rightbar-overlay"></div>

        <!-- Vendor js -->
        <script src="assets/js/vendor.min.js"></script>

        <!-- datatable js -->
        <script src="assets/libs/datatables/jquery.dataTables.min.js"></script>
        <script src="assets/libs/datatables/dataTables.bootstrap4.min.js"></script>
        <script src="assets/libs/datatables/dataTables.responsive.min.js"></script>
        <script src="assets/libs/datatables/responsive.bootstrap4.min.js"></script>
        
        <script src="assets/libs/datatables/dataTables.buttons.min.js"></script>
        <script src="assets/libs/datatables/buttons.bootstrap4.min.js"></script>
        <script src="assets/libs/datatables/buttons.html5.min.js"></script>
        <script src="assets/libs/datatables/buttons.flash.min.js"></script>
        <script src="assets/libs/datatables/buttons.print.min.js"></script>

        <script src="assets/libs/datatables/dataTables.keyTable.min.js"></script>
        <script src="assets/libs/datatables/dataTables.select.min.js"></script>

        <!-- Datatables init -->
        <script src="assets/js/pages/datatables.init.js"></script>

        <!-- App js -->
        <script src="assets/js/app.min.js"></script>
        
    </body>
</html>

<?php } else {
    header("location:login.php");
    exit;
}?>