<?php
session_start();
include("connection.php");

if (isset($_SESSION['admin'])) {
    include('header.php');
?>
<!-- Page Content Start -->
<div class="content-page">
    <div class="content">
        <div class="container-fluid">

            <!-- Page title box -->
            <div class="page-title-box">
                <ol class="breadcrumb float-right">
                    <li class="breadcrumb-item"><a href="javascript:void(0);">Dashboard</a></li>
                    <li class="breadcrumb-item"><a href="javascript:void(0);">Users</a></li>
                    <li class="breadcrumb-item active">User Tables</li>
                </ol>
                <h4 class="page-title">List of Users</h4>
            </div>

            <!-- User Table -->
            <div class="row">
                <div class="col-12">
                    <div class="card-box">
                        <h4 class="header-title">User Details</h4>
                        <table id="datatable-buttons" class="table table-striped table-bordered dt-responsive nowrap">
                            <thead>
                                <tr>
                                    <th>Fullname</th>
                                    <th>Email</th>
                                    <th>Username</th>
                                    <th>Mobile</th>
                                    <th>Total Balance</th>
                                    <th>Profit Balance</th>
                                    <th>KYC Status</th>
                                    <th>Date</th>
                                    <th>Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php
                                $query_history = "SELECT firstname, lastname, email, username, mobile, total_balance, profit_balance, kyc_status, created_at 
                                                  FROM users 
                                                  ORDER BY created_at DESC";
                                $result = mysqli_query($myConn, $query_history);

                                while ($row = mysqli_fetch_assoc($result)) {
                                    $fullname = $row["firstname"] . ' ' . $row["lastname"];
                                    $email = $row["email"];
                                    $username = $row["username"];
                                    $phone = $row["mobile"];
                                    $total_balance = $row["total_balance"];
                                    $profit_balance = $row["profit_balance"];
                                    $kyc_status = ucfirst($row["kyc_status"]);
                                    $date = date("Y-m-d H:i:s", strtotime($row["created_at"]));
                                ?>
                                    <tr>
                                        <td><?php echo htmlspecialchars($fullname); ?></td>
                                        <td><?php echo htmlspecialchars($email); ?></td>
                                        <td><?php echo htmlspecialchars($username); ?></td>
                                        <td><?php echo htmlspecialchars($phone); ?></td>
                                        <td><?php echo number_format($total_balance, 2); ?></td>
                                        <td><?php echo number_format($profit_balance, 2); ?></td>
                                        <td><?php echo htmlspecialchars($kyc_status); ?></td>
                                        <td><?php echo htmlspecialchars($date); ?></td>
                                        <td>
                                            <a href="fundusers.php?fund&email=<?php echo urlencode($email); ?>" class="btn btn-success btn-sm">
                                                Fund
                                            </a>
                                            <a href="javascript:void(0);" onclick="confirmDelete('<?php echo addslashes($email); ?>')" class="btn btn-danger btn-sm">
                                                Delete
                                            </a>
                                        </td>
                                    </tr>
                                <?php } ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
            <!-- end row -->

        </div>
    </div>
</div>

<!-- Footer -->
<footer class="footer">
    <div class="container-fluid">
        <div class="row">
            <div class="col-md-12 text-center">
                <script>document.write(new Date().getFullYear())</script> © <?= $sitename ?>
            </div>
        </div>
    </div>
</footer>

</div>


<?php


if (isset($_GET['user_delete']) && $_GET['user_delete'] === 'delete' && isset($_GET['email'])) {
    $email = mysqli_real_escape_string($myConn, $_GET['email']);
    $delete = "DELETE FROM users WHERE email = '$email'";
    if (mysqli_query($myConn, $delete)) {
        echo "<script>alert('User deleted successfully'); window.location='users.php';</script>";
    } else {
        echo "<script>alert('Failed to delete user'); window.location='users.php';</script>";
    }
}


?>
<!-- End Page content -->

<!-- Right bar overlay-->
<div class="rightbar-overlay"></div>

<!-- Vendor js -->
<script src="assets/js/vendor.min.js"></script>

<!-- datatable js -->
<script src="assets/libs/datatables/jquery.dataTables.min.js"></script>
<script src="assets/libs/datatables/dataTables.bootstrap4.min.js"></script>
<script src="assets/libs/datatables/dataTables.responsive.min.js"></script>
<script src="assets/libs/datatables/responsive.bootstrap4.min.js"></script>

<script src="assets/libs/datatables/dataTables.buttons.min.js"></script>
<script src="assets/libs/datatables/buttons.bootstrap4.min.js"></script>
<script src="assets/libs/datatables/buttons.html5.min.js"></script>
<script src="assets/libs/datatables/buttons.flash.min.js"></script>
<script src="assets/libs/datatables/buttons.print.min.js"></script>

<script src="assets/libs/datatables/dataTables.keyTable.min.js"></script>
<script src="assets/libs/datatables/dataTables.select.min.js"></script>

<!-- Datatables init -->
<script src="assets/js/pages/datatables.init.js"></script>

<!-- App js -->
<script src="assets/js/app.min.js"></script>

<!-- Delete Confirmation Script -->
<script>
    function confirmDelete(email) {
        if (confirm("Are you sure you want to delete this user? This action cannot be undone.")) {
            window.location.href = 'users.php?user_delete=delete&email=' + encodeURIComponent(email);
        }
    }
</script>

</body>
</html>

<?php
} else {
    header("location:login.php");
    exit;
}
?>
