<?php include 'connection.php';?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?=$sitename;?> Privacy Notice</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            line-height: 1.6;
            color: #333;
            background-color: #f9f9f9;
            margin: 0;
            padding: 0;
        }
        header {
            background-color: #00a8e0;
            color: #fff;
            padding: 1em 0;
            text-align: center;
        }
        .container {
            max-width: 70%;
            margin: 20px auto;
            background: #fff;
            padding: 20px;
            border-radius: 8px;
            box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1);
        }
        h1, h2 {
            color: #00a8e0;
        }
        h1 {
            font-size: 2em;
        }
        h2 {
            font-size: 1.5em;
            margin-top: 20px;
        }
        p, li {
            margin: 10px 0;
        }
        ul {
            padding-left: 20px;
        }
        a {
            color: #00a8e0;
            text-decoration: none;
        }
        a:hover {
            text-decoration: underline;
        }
        footer {
            text-align: center;
            padding: 10px 0;
            background: #333;
            color: #fff;
            margin-top: 20px;
        }
        @media (max-width: 768px) {
            .container {
                width: 90%;
                padding: 15px;
            }
            h1 {
                font-size: 1.8em;
            }
            h2 {
                font-size: 1.3em;
            }
        }
    </style>
</head>
<body>
    <header>
        <h1 style="color:white;"><?=$sitename;?> Privacy Notice</h1>
        <p>Last Updated: March 24, 2023</p>
    </header>

    <div class="container"> 
        <p>At <?=$sitename;?>, we want you to have a great experience using our services. An important part of your experience is trusting that the personal and financial information we collect about you is protected. We are committed to maintaining the confidentiality and integrity of your personal information and have implemented business procedures that are consistent with this Privacy Notice ("Notice") and comply with applicable law.</p>
        
        <h2>1. The Information We Collect</h2>
        <p>In the course of providing the Services, <?=$sitename;?> collects or receives the following types of information, which includes personal information/data:</p>
        <ul>
            <li><strong>Identity data:</strong> Full name, date of birth, nationality identification number (e.g., social security number, passport number), nationality/citizenship.</li>
            <li><strong>Contact data:</strong> Email, phone number, mailing/home address information.</li>
            <li><strong>Financial data:</strong> Bank account and payment card details, personal income, account balance, credit scores, and tax information.</li>
            <li><strong>Usage information:</strong> Device identifiers, IP addresses, browser type, and other technical details.</li>
        </ul>

        <h2>2. How We Use and Share Your Information</h2>
        <p>We use and process your information for the following purposes:</p>
        <ul>
            <li>Onboard you as a customer, including identity verification.</li>
            <li>Provide and personalize the Services for you.</li>
            <li>Monitor, support, and improve the Services.</li>
            <li>Protect the safety and security of our Services, business, and customers.</li>
            <li>Comply with legal and regulatory requirements.</li>
        </ul>

        <h2>3. Cookies</h2>
        <p>Our website may use cookies and similar tracking technology to collect information about your visit, such as IP address, browser type, and pages visited. Cookies enable us to personalize your experience, maintain a session, and improve the Services. You can manage cookies in your browser settings.</p>

        <h2>4. Analytics, Tracking, and Advertising</h2>
        <p>We use third-party advertising and analytics services (e.g., Google Analytics) to understand your online activity and provide content relevant to your preferences. These services collect data about your use of our Services and other websites over time.</p>

        <h2>5. How We Protect Your Information</h2>
        <p><?=$sitename;?> uses industry-standard security measures to protect information under our control from unauthorized access. However, no security system is impenetrable. We retain your information for as long as necessary to meet legal obligations and legitimate business interests.</p>

        <h2>6. Managing Your Information</h2>
        <p>You can manage your information through the following means:</p>
        <ul>
            <li>Access and change your information through your Account.</li>
            <li>Withdraw consent to data processing by contacting us.</li>
            <li>Delete your Account through the app settings.</li>
        </ul>

        <h2>7. Transfers of Your Information</h2>
        <p>Your data may be transferred and stored in the United States or other countries where <?=$sitename;?> operates. We implement appropriate safeguards for cross-border data transfers as required by law.</p>

        <h2>8. Third-Party Sites</h2>
        <p>This Privacy Notice does not apply to third-party websites that we do not control. Please review their privacy policies separately.</p>

        <h2>9. California and Nevada Residents</h2>
        <p>California residents have rights under the CCPA, including the right to know, request deletion, and opt-out of data sales. Nevada residents may request that we do not sell their personal information. Contact us for more details.</p>

        <h2>10. Changes to This Notice</h2>
        <p>We may update this Notice at any time. Continued use of our Services implies consent to the updated Notice.</p>

        <h2>11. How to Contact Us</h2>
        <p>If you have any questions, contact us at <a href="mailto:support@<?=$sitename;?>.com">support@<?=$sitename;?>.com</a> or call us toll-free at +1 (888) 828-0618.</p>
    </div>

    <footer>
        <p>&copy; 2023 <?=$sitename;?>. All rights reserved.</p>
    </footer>
</body>
</html>
