<?php include "header.php";

if (isset($_POST['submitinfo'])) {
    try {
        // Get form data and sanitize
        $userId = $_SESSION['user_id']; // Assuming you have user's ID in session
        
        // Basic profile information
        $firstname = filter_input(INPUT_POST, 'firstname', FILTER_SANITIZE_STRING);
        $lastname = filter_input(INPUT_POST, 'lastname', FILTER_SANITIZE_STRING);
        $state = filter_input(INPUT_POST, 'state', FILTER_SANITIZE_STRING);
        $city = filter_input(INPUT_POST, 'city', FILTER_SANITIZE_STRING);
        $zip = filter_input(INPUT_POST, 'zip', FILTER_SANITIZE_STRING);
        $address = filter_input(INPUT_POST, 'address', FILTER_SANITIZE_STRING);
    
        // Email notifications
        $email_deposit = isset($_POST['email_deposit']) ? 1 : 0;
        $email_withdraw = isset($_POST['email_withdraw']) ? 1 : 0;
        $email_trade = isset($_POST['email_trade']) ? 1 : 0;
        $email_account_update = isset($_POST['email_account_update']) ? 1 : 0;
        $email_login_notification = isset($_POST['email_login_notification']) ? 1 : 0;
    
        // Push notifications
        $push_deposit = isset($_POST['push_deposit']) ? 1 : 0;
        $push_withdraw = isset($_POST['push_withdraw']) ? 1 : 0;
        $push_trade = isset($_POST['push_trade']) ? 1 : 0;
        $push_account_update = isset($_POST['push_account_update']) ? 1 : 0;
    
        // Prepare the SQL statement for user profile update
        $sql = "UPDATE users SET 
                firstname = ?, 
                lastname = ?, 
                state = ?, 
                city = ?, 
                zip = ?, 
                address = ?, 
                updated_at = NOW() 
                WHERE id = ?";
    
        // Prepare and bind parameters
        if ($stmt = $conn->prepare($sql)) {
            $stmt->bind_param('sssssss', $firstname, $lastname, $state, $city, $zip, $address, $userId);
            
            // Execute the statement
            $stmt->execute();
            $stmt->close();
        }
    
        // Handle image upload if present
        if (!empty($_FILES['image']['name'])) {
            $allowedTypes = ['image/jpeg', 'image/png', 'image/gif'];
            $maxSize = 5 * 1024 * 1024; // 5MB
    
            if (in_array($_FILES['image']['type'], $allowedTypes) && $_FILES['image']['size'] <= $maxSize) {
                $imageData = file_get_contents($_FILES['image']['tmp_name']);
                
                // Update profile image in the database
                $sql = "UPDATE users SET profile_image = ? WHERE id = ?";
                if ($stmt = $conn->prepare($sql)) {
                    $stmt->bind_param('bi', $null = NULL, $userId); // 'b' for blob and 'i' for integer
                    $stmt->send_long_data(0, $imageData); // Send image as long data
                    $stmt->execute();
                    $stmt->close();
                }
            }
        }
    
        // Return success response
        $response = ['success' => true, 'message' => 'Profile updated successfully'];
        echo json_encode($response);
    
    } catch (Exception $e) {
        // Log error and return error response
        error_log("Profile update error: " . $e->getMessage());
        $response = ['success' => false, 'message' => 'An error occurred while updating your profile'];
        echo json_encode($response);
    } finally {
        // Close the connection
        $conn->close();
    }
}



if (isset($_POST['submitpassword'])) {
    try {
        // Start session and include database connection
        session_start();

        if (!isset($_SESSION['user_id'])) {
            throw new Exception("User not logged in.");
        }

        // Get form data and sanitize
        $userId = $_SESSION['user_id'];
        $current_password = trim(filter_input(INPUT_POST, 'current_password', FILTER_SANITIZE_STRING));
        $new_password = trim(filter_input(INPUT_POST, 'password', FILTER_SANITIZE_STRING));

        if (empty($current_password) || empty($new_password)) {
            throw new Exception("Both current and new passwords are required.");
        }

        // Fetch the current password hash from the database
        $sql = "SELECT password FROM users WHERE id = ?";
        $stmt = $conn->prepare($sql);
        $stmt->bind_param('i', $userId);
        $stmt->execute();
        $stmt->bind_result($stored_password_hash);
        $stmt->fetch();
        $stmt->close();

        if (!$stored_password_hash) {
            throw new Exception("User not found.");
        }

        // Verify the current password
        if (!password_verify($current_password, $stored_password_hash)) {
            throw new Exception("Current password is incorrect.");
        }

        // Hash the new password
        $hashed_new_password = password_hash($new_password, PASSWORD_DEFAULT);

        // Update the password in the database
        $sql = "UPDATE users SET password = ?, updated_at = NOW() WHERE id = ?";
        $stmt = $conn->prepare($sql);
        $stmt->bind_param('si', $hashed_new_password, $userId);
        $stmt->execute();

        if ($stmt->affected_rows === 0) {
            throw new Exception("Password update failed. Please try again.");
        }

        $stmt->close();

        // Success response
        $response = ['success' => true, 'message' => 'Password updated successfully'];
        echo json_encode($response);
    } catch (Exception $e) {
        // Log the error and return a secure error message
        error_log("Password update error: " . $e->getMessage());
        $response = ['success' => false, 'message' => $e->getMessage()];
        echo json_encode($response);
    } finally {
        // Close the connection
        if (isset($conn)) {
            $conn->close();
        }
    }
}


?>


                <div class="dashboard-body">
                   
                        <h4 class="mb-4">Settings</h4>
                    
<style>
    .nav-tabs {
    display: flex;
    justify-content: space-around;
    margin-bottom: 20px;
}

.tab {
    flex-grow: 1;
    margin: 0 4px;
    border: 1px solid #E4E4E4;
    border-radius: 20px;
    text-align: center;
    line-height: 38px;
    font-weight: 600;
    color: #FFF;
    -webkit-transition: all .2s;
    -o-transition: all .2s;
    transition: all .2s;
}

[data-theme=dark] .tab {
    color: #000000; 
}

[data-theme=dark] .tab.active{
 background-color: #e4e4e44d;   
}

.container {
        max-width: 100%;
    }

.nav-tabs {
    border-bottom: none;
}
.tab.active {
    background-color: #191B20;
    color: #3762fb;
}

.tab-content {
    display: none;
    padding-bottom: 20rem;
    
}

.tab-content.active {
    display: block;
}

/* Container Styles */
.popup__row {
    display: flex;
    justify-content: space-between;
}

.popup__field {
    background-color: #f9f9f9;
    padding: 20px;
    border-radius: 8px;
    width: 45%;
}

.popup__label {
    font-weight: bold;
    margin-bottom: 10px;
}

/* Checkbox Styles */
.checkbox {
    display: flex;
    align-items: center;
    margin-bottom: 10px;
}

.checkbox__input {
    display: none;
}

.checkbox__in {
    display: flex;
    align-items: center;
    cursor: pointer;
}

.checkbox__tick {
    width: 20px;
    height: 20px;
    border: 2px solid #3762fb;
    border-radius: 4px;
    display: flex;
    align-items: center;
    justify-content: center;
    margin-right: 10px;
    background-color: #fff;
    position: relative;
}

.checkbox__input:checked + .checkbox__in .checkbox__tick {
    background-color: #3762fb;
}

.checkbox__tick::after {
    content: '✔';
    color: white;
    font-size: 16px;
    position: absolute;
    display: none;
}

@media (max-width: 768px) {
    .popup__field {
        width: 100%;
    }
}

.checkbox__input:checked + .checkbox__in .checkbox__tick::after {
    display: block;
}

.checkbox__text {
    font-size: 14px;
    color: #333;
}

</style>
<div class="container">
    
<div class="nav-tabs">
    <button class="tab active" onclick="openTab(event, 'Profile')">Profile</button>
    <button class="tab" onclick="openTab(event, 'Referrals')">Referrals</button>
    <button class="tab" onclick="openTab(event, 'Password')">Password</button>
</div>
<div class="pt-5 pb-5"><hr></div>
<div id="Profile" class="tab-content active">
    <div class="row justify-content-center">
        <div class="col-lg-10">
            <div class="card custom--card">
                <div class="card-body p-0">
                        <div class="row gy-4 justify-content-center flex-wrap-reverse">
                            <div class="col-md-5 col-lg-4">
                                <div class="user-image text-center">
                                    <img src="assets/images/extra_images/avator.jpg">
                                </div>
                                <ul class="list-group list-group-flush h-100 p-3 information-list">
                                    <li class="list-group-item d-flex flex-column justify-content-between border-0 bg-transparent">
                                        <span class="fw-bold text-muted"><?php echo htmlspecialchars($username); ?></span>
                                        <small class="text-muted"> <i class="la la-user"></i> Username</small>
                                    </li>
                                    <li class="list-group-item d-flex flex-column justify-content-between border-0 bg-transparent">
                                        <span class="fw-bold text-muted"><?php echo htmlspecialchars($email); ?></span>
                                        <small class="text-muted"><i class="la la-envelope"></i> Email</small>
                                    </li>
                                    <li class="list-group-item d-flex flex-column justify-content-between border-0 bg-transparent">
                                        <span class="fw-bold text-muted"><?php echo htmlspecialchars($mobile); ?></span>
                                        <small class="text-muted"><i class="la la-mobile"></i> Mobile</small>
                                    </li>
                                    <li class="list-group-item d-flex flex-column justify-content-between border-0 bg-transparent">
                                        <span class="fw-bold text-muted"><?php echo htmlspecialchars($country); ?></span>
                                        <small class="text-muted"><i class="la la-globe"></i> Country</small>
                                    </li>
                                    <li class="list-group-item d-flex flex-column justify-content-between border-0 bg-transparent">
                                        <span class="fw-bold text-muted"><?php echo htmlspecialchars($address); ?></span>
                                        <small class="text-muted"><i class="la la-map-marked"></i> Address</small>
                                    </li>
                                    
                                    <div class="copy-link" id="ref">
                                       <input type="text" class="form-control form--control copyText" id="copyText" value="<?=$siteurl?>/app?reference=Femi" readonly="">
                                       <button class="btn btn--base w-100" data-bs-toggle="tooltip" onclick="copyWalletAddressToClipboard('copyText')" data-original-title="" title="">
                                          <span class="copy-link__icon"><i class="fas fa-solid fa-copy"></i></span>
                                       </button>
                                    </div>
                                </ul>
                            </div>
                            <div class="col-md-7 col-lg-8">
                                <form class="py-3 pe-3 ps-3 ps-md-0" action="" method="post" autocomplete="off"
                                    enctype="multipart/form-data">
                                    <h5 class="mb-3">Update Profile</h5>
                                    <div class="row">
                                        <div class="col-lg-6">
                                            <div class="form-group">
                                                <label class="form-label">First Name</label>
                                                <input type="text" class="form-control form--control" name="firstname" value="<?php echo htmlspecialchars($firstname); ?>" required>
                                            </div>
                                        </div>
                                        <div class="col-lg-6">
                                            <div class="form-group">
                                                <label class="form-label">Last Name</label>
                                                <input type="text" class="form-control form--control" name="lastname" value="<?php echo htmlspecialchars($lastname); ?>" required>
                                            </div>
                                        </div>
                                        <div class="col-lg-6">
                                            <div class="form-group">
                                                <label class="form-label">State</label>
                                                <input type="text" class="form-control form--control" name="state" value="<?php echo htmlspecialchars($state); ?>">
                                            </div>
                                        </div>
                                        <div class="col-lg-6">
                                            <div class="form-group">
                                                <label class="form-label">City</label>
                                                <input type="text" class="form-control form--control" name="city" value="<?php echo htmlspecialchars($city); ?>">
                                            </div>
                                        </div>
                                        <div class="col-lg-6">
                                            <div class="form-group">
                                                <label class="form-label">Zip Code</label>
                                                <input type="text" class="form-control form--control" name="zip" value="<?php echo htmlspecialchars($zip); ?>">
                                            </div>
                                        </div>
                                        <div class="col-lg-6">
                                            <div class="form-group">
                                                <label class="form-label">Address</label>
                                                <input type="text" class="form-control form--control" name="address" value="<?php echo htmlspecialchars($address); ?>">
                                            </div>
                                        </div>
                                        <div class="col-12">
                                            <div class="form-group">
                                                <label class="form-label">Image</label>
                                                <input type="file" class="form-control form--control" name="image">
                                            </div>
                                        </div>
                                    </div>
                                    <br>
                                    <div class="popup__row row">
                                <div class="popup__field col-md-12">
                                    <div class="popup__label">Email</div>
                                    <div class="popup__variants"><label class="checkbox">
                                        <input class="checkbox__input" type="checkbox" name="email_deposit"  checked >
                                        <span class="checkbox__in"><span class="checkbox__tick"></span>
                                        <span class="checkbox__text">Deposit</span></span>
                                        </label>
                                        
                                        <label class="checkbox">
                                            
                                            <input class="checkbox__input" name="email_withdraw" type="checkbox"  checked >
                                            <span class="checkbox__in"><span class="checkbox__tick"></span>
                                            <span class="checkbox__text">Withdrawal</span></span></label>
                                            
                                            <label class="checkbox"><input class="checkbox__input" name="email_trade" type="checkbox"  checked >
                                            <span class="checkbox__in"><span class="checkbox__tick"></span>
                                            <span class="checkbox__text">Trade</span></span>
                                            
                                            </label>
                                            
                                            
                                             <label class="checkbox"><input class="checkbox__input" name="email_account_update" type="checkbox"  checked >
                                            <span class="checkbox__in"><span class="checkbox__tick"></span>
                                            <span class="checkbox__text">Account Update</span></span>
                                            
                                            </label>
                                            
                                            <label class="checkbox"><input class="checkbox__input" name="email_login_notification" type="checkbox"  checked >
                                            <span class="checkbox__in"><span class="checkbox__tick"></span>
                                            <span class="checkbox__text">Login Notification</span></span>
                                            
                                            </label>
                                            
                                        </div>
                                        </div>
                                        
                                        <div class="popup__field col-md-12">
                                            <div class="popup__label">Notification</div>
                                            <div class="popup__variants"><label class="checkbox">
                                                <input class="checkbox__input" type="checkbox" name="push_deposit"  checked >
                                                <span class="checkbox__in"><span class="checkbox__tick"></span>
                                                <span class="checkbox__text">Deposit</span></span>
                                                </label><label class="checkbox">
                                                    
                                                    <input class="checkbox__input" type="checkbox" name="push_withdraw"  checked >
                                                    <span class="checkbox__in"><span class="checkbox__tick"></span>
                                                    <span class="checkbox__text">Withdrawal</span></span></label>
                                                    
                                                    <label class="checkbox"><input class="checkbox__input" type="checkbox" name="push_trade"  checked >
                                                    <span class="checkbox__in"><span class="checkbox__tick"></span>
                                                    <span class="checkbox__text">Trade</span></span>
                                                    
                                                    </label>
                                                    
                                                     <label class="checkbox"><input class="checkbox__input" type="checkbox" name="push_account_update"  checked >
                                                    <span class="checkbox__in"><span class="checkbox__tick"></span>
                                                    <span class="checkbox__text">Account Update</span></span>
                                                    
                                                    </label>
                                                    
                                                    
                                                    </div>
                                        </div>
                                    </div>
                                    <br>
                                    <button type="submit" class="btn btn--base w-100">Update Profile</button>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        </div>
        <div id="Referrals" class="tab-content">
            <h2>Referrals</h2>
            <div class="row gy-4">
                <div class="col-md-12">
                    <div class="card">
                        <div class="card-body p-5">
                            <div class="empty-thumb text-center">
                                <img src="assets/images/extra_images/empty.png" />
                                <p class="fs-14">No data found</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div id="Password" class="tab-content">
    <h2>Password</h2>
    <div class="row justify-content-center mt-4">
        <div class="col-md-8">
            <div class="card custom--card">
                <div class="card-header">
                    <h5 class="card-title">Change Password</h5>
                </div>
                <div class="card-body">
                <form action="user/change-password" method="post">
                    <input type="hidden" name="_token" value="wJ1Qek3ma0yP7hlR2RfalgEcCLQ0c2vb9EgHiQ59">                    <div class="form-group">
                        <label class="form-label">Current Password</label>
                        <input type="password" class="form--control" name="current_password" required autocomplete="current-password">
                    </div>
                    <div class="form-group">
                        <label class="form-label">Password</label>
                        <input type="password" class="form--control " name="password" required autocomplete="current-password">
                    </div>
                    <div class="form-group">
                        <label class="form-label">Confirm Password</label>
                        <input type="password" class="form-control form--control" name="password_confirmation" required autocomplete="current-password">
                    </div>
                    <button type="button" class="btn btn--base w-100">Submit</button>
                </form>
            </div>
        </div>
    </div>
</div>
<div id="Sec" class="tab-content" style="display: block;">
    <h2>Two-Factor Authentication (2FA)</h2>
    <div class="row justify-content-center gy-3">
        <div class="col-md-6">
            <div class="card custom--card">
                <div class="card-header">
                    <h5 class="card-title">Add Your Account</h5>
                </div>
                <div class="card-body">
                <h6 class="mb-3">
                    Use the QR code or setup key on your Google Authenticator app to add your account.                 </h6>
                <div class="form-group mx-auto text-center">
                    <img class="mx-auto" src="https://chart.googleapis.com/chart?chs=200x200&amp;chld=M|0&amp;cht=qr&amp;chl=otpauth%3A%2F%2Ftotp%2Ffemi%40ExpCopyTrading%3Fsecret%3DRURKDADKIPGANMRD">
                </div>
                <div class="form-group">
                    <label class="form-label" for="key">Setup Key</label>
                    <div class="input-group">
                        <input type="text" name="key" value="RURKDADKIPGANMRD" class="form-control form--control referralURL copyText" readonly="" id="key">
                        <button type="button" class="input-group-text copyTextBtn"> <i class="fa fa-copy"></i> </button>
                    </div>
                </div>
                <label><i class="fa fa-info-circle"></i> Help</label>
                <p>Google Authenticator is a multifactor app for mobile devices. It generates timed codes used during the 2-step verification process. To use Google Authenticator, install the Google Authenticator application on your mobile device. <a class="text--base" href="https://play.google.com/store/apps/details?id=com.google.android.apps.authenticator2&amp;hl=en" target="_blank">Download</a></p>
            </div>
        </div>
    </div>
    
    <div class="col-md-6">
                    <div class="card custom--card">
                <div class="card-header">
                    <h5 class="card-title">Enable 2FA Security</h5>
                </div>
                <form action="" method="POST">
                    <div class="card-body">
                        <input type="hidden" name="_token" value="wJ1Qek3ma0yP7hlR2RfalgEcCLQ0c2vb9EgHiQ59">                        <input type="hidden" name="key" value="RURKDADKIPGANMRD">
                        <div class="form-group">
                            <label class="form-label required" for="code">Google Authenticatior OTP</label>
                            <input type="text" class="form-control form--control " name="code" required="" id="code">
                        </div>
                        <button type="submit" class="btn btn--base w-100 ">Submit</button>
                    </div>
                </form>
            </div>
            </div>
        </div>
        </div>
    </div>

    <script>
    function openTab(evt, tabName) {
        // Get all elements with class="tab-content" and hide them
        var tabContents = document.querySelectorAll('.tab-content');
        tabContents.forEach(function(content) {
            content.classList.remove('active');
        });

        // Get all elements with class="tab" and remove the active class
        var tabs = document.querySelectorAll('.tab');
        tabs.forEach(function(tab) {
            tab.classList.remove('active');
        });

        // Show the current tab content and add the active class to the clicked tab
        document.getElementById(tabName).classList.add('active');
        evt.currentTarget.classList.add('active');
    }
</script>


<?php include "modals.php";?>
