<?php
session_start();
include("connection.php");
//error_reporting(0);
if(isset($_SESSION['admin'])){
include('header.php'); 
if(isset($_GET['delete'])){
    if (is_numeric($_GET['delete'])) {
        $trade_id = intval($_GET['delete']);

        $stmt = $conn->prepare("DELETE FROM copy_trades WHERE id = ?");
        $stmt->bind_param("ii", $trade_id);

        if ($stmt->execute()) {
            echo "<script>alert('Trade deleted successfully.'); window.location='copy_trade_history.php';</script>";
        } else {
            echo "<script>alert('Failed to delete trade.'); window.location='copy_trade_history.php';</script>";
        }
    } else {
        echo "<script>alert('Invalid request.'); window.location='copy_trade_history.php';</script>";
    }
}
?>


            <!-- Page Content Start -->
        <div class="content-page">
            <div class="content">
                <div class="container-fluid">

                    <!-- Page title box -->
                   <div class="page-title-box">
                        <ol class="breadcrumb float-right">
                            <li class="breadcrumb-item"><a href="javascript:void(0);">Dashboard</a></li>
                            <li class="breadcrumb-item"><a href="javascript:void(0);">Copy Trade History</a></li>
                            <li class="breadcrumb-item active">Trade Tables</li>
                        </ol>
                        <h4 class="page-title">Trades</h4>
                    </div>
                    <!-- End page title box -->
                    
                    <div class="row">
                        <div class="col-12">
                            <div class="card-box">
                                <h4 class="header-title">Copy Trade History</h4>
                                <table id="datatable-buttons" class="table table-striped table-bordered dt-responsive nowrap">
                                    <thead>
                                        <tr>
                                            <th>Trade Name</th>
                                            <th>Username</th>
                                            <th>Capital</th>
                                            <th>% Gain</th>
                                            <th>Duration</th>
                                            <th>Status</th>
                                            <th>Action</th>
                                        </tr>
                                    </thead>
                    
                                    <tbody>
                                    <?php
                                        $sql = "SELECT ct.*, u.username FROM copy_trades ct 
                                                JOIN users u ON ct.user_id = u.id 
                                                ORDER BY ct.date DESC";
                                        $result = $conn->query($sql);
                                        if ($result->num_rows > 0) {
                                            while ($row = $result->fetch_assoc()) {
                                    ?>

                                        <tr>
                                            <td><?php echo htmlspecialchars($row['trader_name']) ?></td>
                                            <td><?php echo htmlspecialchars($row['username']) ?></td>
                                            <td><?php echo number_format($row['invest_amt'], 2) ?> USD</td>
                                            <td><?php echo htmlspecialchars($row['increase']) ?>%</td>
                                            <td><?php echo htmlspecialchars($row['duration']) ?> days</td>
                                            <td><?php echo htmlspecialchars($row['status']) ?></td>
                                            <td>
                                                <a href='view_trade.php?id=<?php echo $row['id'] ?>' class='btn btn-sm btn-info'>View</a>
                                                <a href='?delete=<?php echo $row['id'] ?>' class='btn btn-sm btn-danger' onclick="return confirm('Are you sure you want to delete this trade?');">Delete</a></td>
                                        </tr>
                                    <?php 
                                        }
                                    }
                                    ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                    <!-- end row -->




                </div> <!-- end container-fluid-->
            </div> <!-- end contant-->
        </div>
        <!-- End Page Content-->
     


                <!-- Footer Start -->
                <footer class="footer">
                    <div class="container-fluid">
                        <div class="row">
                            <div class="col-md-12 text-center">
                                  <script>document.write(new Date().getFullYear())</script> ©  <?=$sitename?>
                            </div>
                        </div>
                    </div>
                </footer>
                <!-- end Footer -->

            </div>

            <!-- ============================================================== -->
            <!-- End Page content -->
            <!-- ============================================================== -->


        </div>
        <!-- END wrapper -->

       

        <!-- Right bar overlay-->
        <div class="rightbar-overlay"></div>

        <!-- Vendor js -->
        <script src="assets/js/vendor.min.js"></script>

        <!-- datatable js -->
        <script src="assets/libs/datatables/jquery.dataTables.min.js"></script>
        <script src="assets/libs/datatables/dataTables.bootstrap4.min.js"></script>
        <script src="assets/libs/datatables/dataTables.responsive.min.js"></script>
        <script src="assets/libs/datatables/responsive.bootstrap4.min.js"></script>
        
        <script src="assets/libs/datatables/dataTables.buttons.min.js"></script>
        <script src="assets/libs/datatables/buttons.bootstrap4.min.js"></script>
        <script src="assets/libs/datatables/buttons.html5.min.js"></script>
        <script src="assets/libs/datatables/buttons.flash.min.js"></script>
        <script src="assets/libs/datatables/buttons.print.min.js"></script>

        <script src="assets/libs/datatables/dataTables.keyTable.min.js"></script>
        <script src="assets/libs/datatables/dataTables.select.min.js"></script>

        <!-- Datatables init -->
        <script src="assets/js/pages/datatables.init.js"></script>

        <!-- App js -->
        <script src="assets/js/app.min.js"></script>
        
    </body>
</html>

<?php } else {
    header("location:login.php");
    exit;
}?>