<?php 
include('connection.php');
include ('header.php');


if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['stop'])) {

    $InvestId = intval($_POST['InvestId']);

    $stmtSelect = $conn->prepare("SELECT ct.*, u.email, u.username FROM investments ct JOIN users u ON ct.userId = u.id WHERE ct.id = ?");
    $stmtSelect->bind_param("i", $InvestId);
    $stmtSelect->execute();
    $result = $stmtSelect->get_result();

    if ($result->num_rows === 0) {
        echo "<script>alert('Investment not found.');</script>";
        exit;
    }

    $row = $result->fetch_assoc();

    // Update status to Active
    $stmtUpdate = $conn->prepare("UPDATE investments SET status = 'Closed' WHERE id = ?");
    $stmtUpdate->bind_param("i", $InvestId);

    if ($stmtUpdate->execute()) {
        // Prepare and send email
        $email = $row['email'];
        $username = $row['username'];
        $subject = 'Investment closed';
        
        $htmlMessage = '
        <!DOCTYPE html>
        <html>
        <head>
            <style>
                body { font-family: Arial, sans-serif; background-color: #f9f9f9; }
                .container { max-width: 600px; margin: 20px auto; background: #fff; padding: 20px; border-radius: 8px; }
                .header { background-color: #015a63; color: white; padding: 15px; text-align: center; font-size: 18px; }
                .details { margin-top: 20px; font-size: 16px; color: #333; }
                .footer { margin-top: 30px; font-size: 13px; color: #777; text-align: center; }
            </style>
        </head>
        <body>
            <div class="container">
                <div class="header">Close of investment</div>
                <div class="details">
                    <p>Hi <strong>' . htmlspecialchars($username) . '</strong>,</p>
                    <p>Your investment has been closed with plan <strong>' . htmlspecialchars($row['plan_name']) . '</strong>.</p>
                    <p><strong>Investment:</strong> $' . number_format($row['invest_amt'], 2) . '<br>
                    <strong>Duration:</strong> ' . $row['duration'] . ' hours<br>
                    <strong>Total Expected Profit:</strong> $' . number_format($row['total_profit'], 2) . '</p>
                    <p>Contact support to know the reason for this action</p>
                </div>
                <div class="footer">
                    &copy; ' . date('Y') . ' ' . $sitename . '. All rights reserved.
                </div>
            </div>
        </body>
        </html>';

        // sendmail(to, name, subject, html)
        sendmail($email, $username, $subject, $htmlMessage);

        echo "<script>alert('Trade approved and user notified via email.'); window.location.href='copy_trade_history.php';</script>";
    } else {
        echo "<script>alert('Failed to approve trade.');</script>";
    }
}

?>

<div id="wrapper">
    <!-- Page Content Start -->
    <div class="content-page">
        <div class="content">
            <div class="container-fluid">

                <!-- Page title box -->
                <div class="page-title-box">
                    <ol class="breadcrumb float-right">

                        <li class="breadcrumb-item"><a href="Transaction.php">Investment</a></li>
                        <li class="breadcrumb-item active">Investment</li>
                    </ol>
                    <h4 class="page-title">Investment</h4>
                </div>
                <!-- End page title box -->
                    <?php
                    // Get transaction ID from the URL
                    $InvestId = $_GET['id'];
                    
                    $sql = "SELECT ct.*, u.username FROM investments ct 
                            JOIN users u ON ct.userId = u.id 
                            WHERE ct.id = '$InvestId' ";
                    $result = $conn->query($sql);
                    $result->num_rows > 0;
                    $row = $result->fetch_assoc();
                  
                    
                    
                    if (isset($_POST['approve'])) {
                        
                    } 
                    
                    ?>
                    
                    <!-- end row -->
                    <div class="row">
                        <div class="col-md-12">
                            <div class="card-box">
                                <form action="" method="post">
                                    <input type="hidden" value="<?php echo $InvestId ?>" name="InvestId">
                                    <div class="form-row">
                                        <div class="form-group col-md-6">
                                            <label class="control-label mb-10 text-left">Trader name: </label>
                                            <input type="text" name="" class="form-control" value="<?= $row['plan_name'] ?>" readonly>
                                        </div>
                                        
                                        <div class="form-group col-md-6">
                                            <label class="control-label mb-10 text-left">Username: </label>
                                            <input type="text" name="username" class="form-control" value="<?= $row['username'] ?>" readonly>
                                        </div>
                    
                                        <div class="form-group col-md-6">
                                            <label class="control-label mb-10 text-left">Amount (USD)</label>
                                            <input type="text" name="amount" class="form-control" value="<?= $row['invest_amt'] ?>" readonly>
                                        </div>
                    
                                        <div class="form-group col-md-6">
                                            <label class="control-label mb-10 text-left">Transaction Date: </label>
                                            <input type="text" class="form-control" value="<?= $row['date'] ?>" readonly>
                                        </div>

                                        <div class="form-group col-md-6">
                                            <label class="control-label mb-10 text-left">Status: </label>
                                            <input type="text" class="form-control" value="<?= $row['status'] ?>" readonly>
                                        </div>
                    
                                        <div class="form-group col-md-12">
                                            <button type="submit" name="stop" class="btn btn-danger btn-block <?= $row['status'] == 'Completed' ? 'disabled' : '' ?>" >Stop Investment</button>
                                        </div>
                                    </div>
                                </form>
                            </div> <!-- end card-box -->
                        </div> <!-- end col -->
                    </div>
                    <!-- end row -->




       <!-- Footer Start -->
                <footer class="footer">
                    <div class="container-fluid">
                        <div class="row">
                            <div class="col-md-12 text-center">
                                  <script>document.write(new Date().getFullYear())</script> ©  <?=$sitename?>
                            </div>
                        </div>
                    </div>
                </footer>
                <!-- end Footer -->

            </div>

            <!-- ============================================================== -->
            <!-- End Page content -->
            <!-- ============================================================== -->


        </div>
        <!-- END wrapper -->

       

        <!-- Right bar overlay-->
        <div class="rightbar-overlay"></div>

        <!-- Vendor js -->
        <script src="assets/js/vendor.min.js"></script>

        <!-- datatable js -->
        <script src="assets/libs/datatables/jquery.dataTables.min.js"></script>
        <script src="assets/libs/datatables/dataTables.bootstrap4.min.js"></script>
        <script src="assets/libs/datatables/dataTables.responsive.min.js"></script>
        <script src="assets/libs/datatables/responsive.bootstrap4.min.js"></script>
        
        <script src="assets/libs/datatables/dataTables.buttons.min.js"></script>
        <script src="assets/libs/datatables/buttons.bootstrap4.min.js"></script>
        <script src="assets/libs/datatables/buttons.html5.min.js"></script>
        <script src="assets/libs/datatables/buttons.flash.min.js"></script>
        <script src="assets/libs/datatables/buttons.print.min.js"></script>

        <script src="assets/libs/datatables/dataTables.keyTable.min.js"></script>
        <script src="assets/libs/datatables/dataTables.select.min.js"></script>

        <!-- Datatables init -->
        <script src="assets/js/pages/datatables.init.js"></script>

        <!-- App js -->
        <script src="assets/js/app.min.js"></script>
        
    </body>
</html>
