<?php
include "connection.php";
// Assuming you're using a MySQLi connection
if ($_SERVER['REQUEST_METHOD'] === 'DELETE') {
    // Get the transaction ID from the URL
    $urlParts = explode('/', $_SERVER['REQUEST_URI']);
    $trx_id = end($urlParts);  // The last part of the URL is the transaction ID

    // Sanitize and prepare SQL query
    $trx_id = (int)$trx_id; // Cast to int for security

    // Prepare the delete query
    $sql = "DELETE FROM transactions WHERE trx_id = ?";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param('i', $trx_id);

    // Execute the query
    if ($stmt->execute()) {
        echo json_encode(['status' => 'success']);
    } else {
        echo json_encode(['status' => 'error']);
    }
}
?>
