<?php include ("header.php");?>

<div class="dashboard-body">
   <div class="d-flex justify-content-between mb-3 align-items-center dashboardBodyNav">
      <!---->
      <!--    <div class="dashboard-body__bar style ">-->
      <!--        <span class="dashboard-body__bar-two-icon toggle-dashboard-right"><i class="fas fa-bars"></i></span>-->
      <!--    </div>-->
      <!---->
   </div>
   <h4 class="mb-4">My Dashboard</h4>
   <script src="https://cdn.jsdelivr.net/npm/chart.js" type="text/javascript"></script>
   <script src="https://code.jquery.com/jquery-3.5.1.slim.min.js" type="text/javascript"></script>
   <script type="text/javascript" src="https://s3.tradingview.com/tv.js"></script>
   <style>
      .round {
      width: 10px;
      height: 10px;
      font-size: 11px;
      font-weight: 600;
      padding-bottom: 1px;
      background: green;
      border-radius: 50%;
      opacity: 1;
      animation: blink 1s infinite;
      }
      @keyframes blink {
      0%, 100% {
      opacity: 1;
      }
      50% {
      opacity: 0;
      }
      }
      .stock-img{
      width: 20px;
      height: 20px;
      border-radius : 50%;
      margin-right: 5px;
      background-color: white!important;
      padding: 1px;
      }
      .nav-tabs .nav-link {
      display: flex;
      align-items: center;
      }
      .nav-tabs {
      flex-wrap: wrap;
      }
      @media (max-width: 576px) {
      .nav-tabs .nav-item {
      flex: 0 0 30%; /* Two items per row on small screens */
      max-width: 30%;
      }
      }
      @media (min-width: 576px) and (max-width: 768px) {
      .nav-tabs .nav-item {
      flex: 0 0 30%; /* Three items per row on medium screens */
      max-width:30%;
      }
      }
      .blurry-background {
      filter: blur(5px);
      }
      .alert-container {
      background-color: #000;
      border: 2px solid #04a8e0;
      border-radius: 10px;
      padding: 20px;
      color: #fff;
      font-size: 18px;
      margin: 0 auto;
      max-width: 400px;
      position: absolute;
      top: 50%; 
      left: 50%; 
      transform: translate(-50%, -50%);
      z-index: 99;
      display: flex;
      justify-content: center;
      align-items: center;
      text-align: center;
      }
      [data-theme=dark] .alert-container {
      background-color: #fff;
      color: #000;
      }
      @media (max-width: 576px) {
      .d-sm-block {
      display: block !important; 
      }
      }
      .alert-container p {
      margin: 0;
      }
      @media (min-width: 1200px) {
      .d-xl-none {
      display: block !important; 
      }
      }
      @media (min-width: 1399px) {
      .d-xl-none {
      display: none !important;
      }
      }
      @media (min-width: 1200px) {
      .d-xl-block {
      display: none !important; 
      }
      }
      @media (min-width: 1399px) {
      .d-xl-block {
      display: block !important;
      }
      }
      @media (min-width: 700px) {
      .nodesktop {
      display: none !important;
      }
      }
      @media (min-width: 1399px) {
      .hide--mobil{
      display: none !important;
      }
      }
   </style>

<!-- Ensure to include SweetAlert2 library -->
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

<div class="container">
    <div class="row justify-content-center gy-4">
        
      <?php if (!checkUserKYC($user_id, $conn)) { ?> 
        
        <div class="col-xxl-9 col-lg-12">
            <div class="col-lg-12">
                <div class="transection h-200">
                    <form id="kycForm" method="post" enctype="multipart/form-data" autocomplete="off">
                        <div class="d-flex flex-between flex-wrap">
                            <div class="mb-2">
                                <h4 class="fs-18">Proof of Identification</h4>
                            </div>
                            <div class="flex-align remove-2fa-notice">
                                <span class="alert__icon">
                                    <i class="fas fa-info"></i>
                                </span>
                                <div class="alert__content d-flex justify-content-between">
                                    <span class="alert__title">
                                        <p class="alert-heading text--danger"></p>
                                        To verify your identification, please upload one of the following proof of identification documents: ID Card, passport or driver's license. All sides containing your personal details are required.
                                        <span class="mt-2">The documents must include: full name, ID number, photograph, date of birth, place of birth, nationality</span>
                                    </span>
                                </div>
                            </div>
                        </div>
                        <hr>
                        <div class="d-flex justify-content-between flex-wrap" style="gap: 2rem!important;">
                            <div class="btn btn--primary flex-fill btn--lg" id="btn-id" onclick="selectDocument('ID')">ID</div>
                            <div class="btn btn--primary outline flex-fill btn--lg" id="btn-passport" onclick="selectDocument('Passport')">Passport</div>
                            <div class="btn btn--primary outline flex-fill btn--lg" id="btn-drivers" onclick="selectDocument('Driver\'s Licence')">Driver's Licence</div>
                            <input type="hidden" name="document_type" id="document_type" value="ID">
                        </div>
                        <div class="row mt-3">
                            <div class="col-md-6" id="front-side-container" style="display: block;">
                                <label>Front Side</label>
                                <div style="height: 200px; border: 1px dashed #ccc; position: relative; overflow: hidden;">
                                    <input type="file" accept="image/jpeg, image/png, image/jpg" style="position: absolute; top: 0; left: 0; width: 100%; height: 100%; opacity: 0;" name="front_image" id="front-side-input" onchange="previewImage('front')">
                                    <img id="front-side-preview" style="display:none; width: 100%; height: 100%; object-fit: cover;">
                                    <span class="d-flex justify-content-center align-items-center h-100" id="front-side-upload">
                                        <i class="fas fa-image"></i> Upload
                                    </span>
                                </div>
                            </div>
                            <div class="col-md-6" id="back-side-container" style="display: block;">
                                <label>Back Side</label>
                                <div style="height: 200px; border: 1px dashed #ccc; position: relative; overflow: hidden;">
                                    <input type="file" accept="image/jpeg, image/png, image/jpg" style="position: absolute; top: 0; left: 0; width: 100%; height: 100%; opacity: 0;" name="back_image" id="back-side-input" onchange="previewImage('back')">
                                    <img id="back-side-preview" style="display: none; width: 100%; height: 100%; object-fit: cover;">
                                    <span class="d-flex justify-content-center align-items-center h-100" id="back-side-upload">
                                        <i class="fas fa-image"></i> Upload
                                    </span>
                                </div>
                            </div>
                        </div>
                        <div class="alert-bar mt-2" id="alert-bar">Invalid file type. Please upload a JPEG, PNG, or JPG image.</div>
                        <div class="alert-bar mt-2" id="no-img-bar">Front and Back Image is required.</div>
                        <div class="alert-bar mt-2" id="no-img2-bar">Front Image is required.</div>
                        <div class="row mt-3">
                            <div class="col-md-6">
                                <label>Document Number</label>
                                <input type="text" class="form--control form-control" name="id_number" required="" id="id_number">
                            </div>
                            <div class="col-md-6">
                                <label>Expiry Date</label>
                                <input type="date" class="form--control form-control" name="exp_date" style="text-transform: uppercase;" required="">
                            </div>
                        </div>
                        <div class="d-flex justify-content-center mt-3 p-2">
                            <button type="submit" class="btn btn-primary" id="submit-button">
                                <span class="indicator-label">Submit Proof of Identification</span>
                                <span class="indicator-progress" style="display: none;">
                                    Please wait... <span class="spinner-border spinner-border-sm align-middle ms-2"></span>
                                </span>
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
        
        
        <div class="col-xxl-3">
            <div class="right-sidebar mt-3">
                <div class="right-sidebar__header mb-3">
                    <div class="d-flex flex-between flex-wrap">
                        <div>
                            <h4 class="mb-0 fs-18">Upload Documents</h4>
                        </div>
                    </div>
                </div>
                <div>
                    <p class="d-flex">
                        <span class="alert__icon">
                            <i class="fas fa-exclamation"></i>
                        </span>
                        <strong class="mb-2"> &nbsp; Proof of Identification</strong></p>
                </div>
            </div>
        </div>
        
        <?php }elseif($kyc_status == "Approved"){
        ?>
        <div class="col-xxl-9 col-lg-12">
            <div class="col-lg-12">
                <div class="transection h-200">
                    <div class="d-flex flex-between flex-wrap">
                        <div class="mb-2">
                            <h4 class="fs-18">Hey <?=$username?> ✋ !</h4>
                        </div>
                        <div class="flex-align remove-2fa-notice">
            
                            <div class=" d-flex justify-content-between">
                                <span class="alert__title">
                                    <p class="alert-heading text--danger"></p>
                                      Your verification document has been verified successfully
                                    
                                     <div class="alert alert--primary mt-2" style="background-color: #007bff!important; color: white;width: 60%;" role="alert">
                                          <span style="font-weight: 600;"> Approved Verification! <i class="fa fa-check"></i></span>
                                        </div>
                                      <br>
                  
                                    <span class="mt-2">Your account verification is currently approved and verified. <br><br><br></span>
                                </span>
                            </div>
                        </div>
                    </div>
                    <hr>
                </div>
            </div>
        </div>
        <?php
        }else{?>
        
        <div class="col-xxl-9 col-lg-12">
            <div class="col-lg-12">
                <div class="transection h-200">
                    <div class="d-flex flex-between flex-wrap">
                        <div class="mb-2">
                            <h4 class="fs-18">Hey <?=$username?> ✋ !</h4>
                        </div>
                        <div class="flex-align remove-2fa-notice">
            
                            <div class=" d-flex justify-content-between">
                                <span class="alert__title">
                                    <p class="alert-heading text--danger"></p>
                                      Your verification document has been submitted successfully, kindly wait for admin approval.
                                    
                                     <div class="alert alert--primary mt-2" style="background-color: #007bff!important; color: white;width: 60%;" role="alert">
                                          <span style="font-weight: 600;"> Pending Verification! <i class="fa fa-spinner fa-spin"></i></span>
                                        </div>
                                      <br>
                  
                                    <span class="mt-2">Your account verification is currently pending and awaiting verification. <br>Our team is diligently reviewing the information you provided to ensure the security and authenticity of your account. <br><br>We appreciate your patience during this process and will notify you as soon as the verification is complete.</span>
                                </span>
                            </div>
                        </div>
                    </div>
                    <hr>
                </div>
            </div>
        </div>
       
        
        <div class="col-xxl-3">
            <div class="right-sidebar mt-3">
                <div class="right-sidebar__header mb-3">
                    <div class="d-flex flex-between flex-wrap">
                        <div>
                            <h4 class="mb-0 fs-18">Upload Documents</h4>
                        </div>
                    </div>
                </div>
                <div>
                    <p class="d-flex">
                        <span class="alert__icon">
                            <i class="fa fa-spinner fa-spin"></i>
                        </span>
                        <strong class="mb-2"> &nbsp; Proof of Identification</strong></p>
                </div>
            </div>
        </div>
         <?php }?>
    </div>
</div>

<script type="text/javascript">
    // Function to change the document type based on selected button
    function selectDocument(type) {
        document.getElementById('document_type').value = type;

        // Update button styles to highlight the selected document type
        document.querySelectorAll('.btn').forEach(function(btn) {
            btn.classList.remove('btn--primary');
            btn.classList.add('btn--primary', 'outline');
        });
        document.getElementById('btn-' + type.toLowerCase().replace(/ /g, '-')).classList.add('btn--primary');
        document.getElementById('btn-' + type.toLowerCase().replace(/ /g, '-')).classList.remove('outline');
    }

    // Function to preview uploaded image inside the bordered box
    function previewImage(side) {
        var input = document.getElementById(side + '-side-input');
        var preview = document.getElementById(side + '-side-preview');
        var file = input.files[0];

        if (file) {
            var reader = new FileReader();
            reader.onload = function (e) {
                preview.style.display = 'block';
                preview.src = e.target.result;
            }
            reader.readAsDataURL(file);
        } else {
            preview.style.display = 'none';
        }
    }

    // Form submission with AJAX
    document.getElementById('kycForm').addEventListener('submit', function(e) {
        e.preventDefault(); // Prevent the default form submission

        var formData = new FormData(this); // Collect the form data

        // Show loading indicator
        var button = document.getElementById('submit-button');
        button.querySelector('.indicator-label').style.display = 'none';
        button.querySelector('.indicator-progress').style.display = 'inline-block';
        button.disabled = true;

        // Make AJAX request using fetch
        fetch('processor.php?submit-kyc', {
        method: 'POST',
        body: formData,
    })
        .then(response => response.json()) // Assuming the response is JSON
        .then(data => {
            // Handle success or error
            if (data.success) {
                Swal.fire({
                    icon: 'success',
                    title: 'Success',
                    text: 'KYC submitted successfully!',
                }).then(() => {
                    // Refresh the page after a successful submission
                    window.location.reload();
                });
            } else {
                Swal.fire({
                    icon: 'error',
                    title: 'Error',
                    text: 'Error: ' + data.message,
                });
            }
        })
        .catch(error => {
            // Handle network or server error
            Swal.fire({
                icon: 'error',
                title: 'Error',
                text: 'There was an error submitting the form.',
            });
        })
        .finally(() => {
            // Hide loading indicator and re-enable the button
            button.querySelector('.indicator-label').style.display = 'inline-block';
            button.querySelector('.indicator-progress').style.display = 'none';
            button.disabled = false;
        });
});
</script>


<?php include "modals.php";?>
