<?php
session_start();

if (!isset($_SESSION['user_id'])) {
    header('Location: ../app/login'); 
    exit(); 
}
$_SESSION['mode'] = 'demo';
$mode = $_SESSION['mode'];
$buttonLabel = $mode === 'live' ? 'Switch To Demo' : 'Switch To Live';
$buttonClass = $mode === 'live' ? 'live-mode' : 'demo-mode';
$user_id = $_SESSION['user_id'];
$username = @$_SESSION['username'];

include "connection.php";

// Fetch user balance
$sql_balance = "SELECT * FROM users WHERE id = ?";
$stmt_balance = $conn->prepare($sql_balance);
$stmt_balance->bind_param("i", $user_id); // Assuming you have a user ID variable
$stmt_balance->execute();
$result_balance = $stmt_balance->get_result();
$row = $result_balance->fetch_assoc(); // Fetch the row once

$total_balance = $row['total_balance'];
$kyc_status = $row['kyc_status'];
$email = $row['email'];
$mobile = $row['mobile'];
$address = $row['address'];
$country = $row['country'];
$firstname = $row['firstname'];
$lastname = $row['lastname'];
$state = $row['state'];
$city = $row['city'];
$zip = $row['zip'];

?>

<html lang="en" itemscope="" itemtype="http://schema.org/WebPage" data-theme="light">
   <div id="in-page-channel-node-id" data-channel-name="in_page_channel_VGJKjw"></div>
   <head>
      <meta charset="utf-8">
      <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
      <title> <?php echo $sitename; ?> - Demo Trading</title>
      <meta name="title" content="<?php echo $sitename; ?> - Demo Trading">
      <meta name="description" content="Introducing copy trading as a product can substantially boost a newbie/pro profits turnover by copying and earning with expert traders on financial markets.">
      <meta name="keywords" content="crypto currency,fiat currency,crypto sell,crypto buy,copy,copytrading,copy trade,trading,<?php echo $sitename; ?>">
      <link rel="shortcut icon" href="assets/images/logoIcon/favicon.png" type="image/x-icon">
      <link rel="apple-touch-icon" href="assets/images/logoIcon/logo.png">
      <meta name="apple-mobile-web-app-capable" content="yes">
      <meta name="apple-mobile-web-app-status-bar-style" content="black">
      <meta name="apple-mobile-web-app-title" content="<?php echo $sitename; ?> - Demo Trading">
      <meta itemprop="name" content="<?php echo $sitename; ?> - Demo Trading">
      <meta itemprop="description" content="Introducing copy trading as a product can substantially boost a newbie/pro profits turnover by copying and earning with expert traders on financial markets.">
      <meta itemprop="image" content="assets/images/seo/66a655a7593c91722176935.png">
      <meta property="og:type" content="website">
      <meta property="og:title" content="Copy/Social Trading Platform - <?php echo $sitename; ?>">
      <meta property="og:description" content="Introducing copy trading as a product can substantially boost a newbie/pro profits turnover by copying and earning with expert traders on financial markets.">
      <meta property="og:image" content="assets/images/seo/66a655a7593c91722176935.png">
      <meta property="og:image:type" content="png">
      <meta property="og:image:width" content="1180">
      <meta property="og:image:height" content="600">
      <meta property="og:url" content="trade">
      <meta name="twitter:card" content="summary_large_image">
      <link href="assets/global/css/bootstrap.min.css" rel="stylesheet">
      <link href="assets/global/css/all.min.css" rel="stylesheet">
      <link rel="stylesheet" href="assets/global/css/line-awesome.min.css">
      <link rel="stylesheet" href="assets/templates/basic/css/main.css">
      <link rel="stylesheet" href="assets/templates/basic/css/custom.css">
      <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/intro.js/7.2.0/introjs.min.css">
      <link rel="manifest" href="pwa/configuration">
      <link rel="stylesheet" href="assets/templates/basic/css/color.php?color=00a8e0">
      <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
      <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/line-awesome/1.3.0/line-awesome/css/line-awesome.min.css" integrity="sha512-mE59l9+NiA7V71+0iNq5OWl7N6KLdfVnMnQUh8c3TqMzJXZEU5+GhXBk2KU2AGo4V2RLHgRFFurzy0zGOGZB2A==" crossorigin="anonymous" referrerpolicy="no-referrer" />
      <script type="text/javascript">
         // Check if 'theme' exists in LocalStorage
             if (!localStorage.getItem('theme')) {
                 
                 localStorage.setItem('theme', 'light');
             }
         
      </script>
      <style>



         .trading-header__title {
         color: hsl(0deg 0% 100%);
         }
         .equity-info{
         display: flex;
         justify-content: space-between;
         align-items: center;
         flex-wrap: wrap;
         }
         .custom--tab .nav-item .nav-link {
         color: hsl(0deg 0% 100% / 50%) !important;
         }
         .demo-banner {
         position: absolute;
         top: 10px;
         right: 10px;
         background-color: blue;
         color: white;
         font-size: 12px;
         font-weight: bold;
         padding: 5px 10px;
         border-radius: 3px;
         text-transform: uppercase;
         }
         .input-group-text {
         background-color: #1e1e1e;
         }
         .green {
         color: green;
         font-weight: 600;
         }
         .blue {
         color: blue;
         font-weight: 600;
         }
         .mega-menu-list__item {
         padding: 25px 20px!important;
         }
         .small, small {
         font-size: .90em!important;
         }
         .has-mega-menu .mega-menu {
         width: 500px!important;
         }
      </style>
      <style>
         .introjs-tooltip {
         background-color: #000000!important;
         color: #fff!important;
         }
         .introjs-button {
         background-color: #3762fb!important;
         color: #fff!important;
         }
         .introjs-disabled {
         background-color: #FFF!important;
         color: #3762fb!important;
         }
      </style>
      <style>
         @keyframes slide-in-one-tap {
         from {
         transform: translateY(80px);
         }
         to {
         transform: translateY(0px);
         }
         }
         .trust-hide-gracefully {
         opacity: 0;
         }
         .trust-wallet-one-tap .hidden {
         display: none;
         }
         .trust-wallet-one-tap .semibold {
         font-weight: 500;
         }
         .trust-wallet-one-tap .binance-plex {
         font-family: 'Binance';
         }
         .trust-wallet-one-tap .rounded-full {
         border-radius: 50%;
         }
         .trust-wallet-one-tap .flex {
         display: flex;
         }
         .trust-wallet-one-tap .flex-col {
         flex-direction: column;
         }
         .trust-wallet-one-tap .items-center {
         align-items: center;
         }
         .trust-wallet-one-tap .space-between {
         justify-content: space-between;
         }
         .trust-wallet-one-tap .justify-center {
         justify-content: center;
         }
         .trust-wallet-one-tap .w-full {
         width: 100%;
         }
         .trust-wallet-one-tap .box {
         transition: all 0.5s cubic-bezier(0, 0, 0, 1.43);
         animation: slide-in-one-tap 0.5s cubic-bezier(0, 0, 0, 1.43);
         width: 384px;
         border-radius: 15px;
         background: #FFF;
         box-shadow: 0px 2px 4px 0px rgba(0, 0, 0, 0.25);
         position: fixed;
         right: 30px;
         bottom: 30px;
         z-index: 1020;
         }
         .trust-wallet-one-tap .header {
         gap: 15px;
         border-bottom: 1px solid #E6E6E6;
         padding: 10px 18px;
         }
         .trust-wallet-one-tap .header .left-items {
         gap: 15px
         }
         .trust-wallet-one-tap .header .title {
         color: #1E2329;
         font-size: 18px;
         font-weight: 600;
         line-height: 28px;
         }
         .trust-wallet-one-tap .header .subtitle {
         color: #474D57;
         font-size: 14px;
         line-height: 20px;
         }
         .trust-wallet-one-tap .header .close {
         color: #1E2329;
         cursor: pointer;
         }
         .trust-wallet-one-tap .body {
         padding: 9px 18px;
         gap: 10px;
         }
         .trust-wallet-one-tap .body .right-items {
         gap: 10px;
         width: 100%;
         }
         .trust-wallet-one-tap .body .right-items .wallet-title {
         color: #1E2329;
         font-size: 16px;
         font-weight: 600;
         line-height: 20px;
         }
         .trust-wallet-one-tap .body .right-items .wallet-subtitle {
         color: #474D57;
         font-size: 14px;
         line-height: 20px;
         }
         .trust-wallet-one-tap .connect-indicator {
         gap: 15px;
         padding: 8px 0;
         }
         .trust-wallet-one-tap .connect-indicator .flow-icon {
         color: #474D57;
         }
         .trust-wallet-one-tap .loading-color {
         color: #FFF;
         }
         .trust-wallet-one-tap .button {
         border-radius: 50px;
         outline: 2px solid transparent;
         outline-offset: 2px;
         background-color: rgb(5, 0, 255);
         border-color: rgb(229, 231, 235);
         cursor: pointer;
         text-align: center;
         height: 45px;
         }
         .trust-wallet-one-tap .button .button-text {
         color: #FFF;
         font-size: 16px;
         font-weight: 600;
         line-height: 20px;
         }
         .trust-wallet-one-tap .footer {
         margin: 20px 30px;
         }
         .trust-wallet-one-tap .check-icon {
         color: #FFF;
         }
         @font-face {
         font-family: 'Binance';
         src: url(chrome-extension://egjidjbpglichdcondbcbdnbeeppgdph/fonts/BinancePlex-Regular.otf) format('opentype');
         font-weight: 400;
         font-style: normal;
         }
         @font-face {
         font-family: 'Binance';
         src: url(chrome-extension://egjidjbpglichdcondbcbdnbeeppgdph/fonts/BinancePlex-Medium.otf) format('opentype');
         font-weight: 500;
         font-style: normal;
         }
         @font-face {
         font-family: 'Binance';
         src: url(chrome-extension://egjidjbpglichdcondbcbdnbeeppgdph/fonts/BinancePlex-SemiBold.otf) format('opentype');
         font-weight: 600;
         font-style: normal;
         }
      </style>
   </head>
   <body>
      <div class="progress-cricle">
         <h4 class="progress-cricle__number"></h4>
      </div>
      <div class="preloader-wrapper" style="display: none;">
         <div class="preloader">
            <div class="wrapper">
               <div class="loader">
                  <div class="dot"></div>
               </div>
               <div class="loader">
                  <div class="dot"></div>
               </div>
               <div class="loader">
                  <div class="dot"></div>
               </div>
               <div class="loader">
                  <div class="dot"></div>
               </div>
               <div class="loader">
                  <div class="dot"></div>
               </div>
               <div class="loader">
                  <div class="dot"></div>
               </div>
            </div>
         </div>
      </div>
      <div class="body-overlay"></div>
      <div class="sidebar-overlay"></div>
      <a class="scroll-top"><i class="fas fa-angle-double-up"></i></a>
      <style>
         a:hover {
         color: inherit!important;
         }
         a:hover {
         text-decoration: none!important;
         }
         .header {
         padding-top: .7rem;
         }
         .live-banner {
         top: 10px;
         right: 0px;
         background-color: green;
         color: white;
         font-size: 12px;
         font-weight: bold;
         padding: 5px 10px;
         border-radius: 3px;
         text-transform: uppercase;
         }
         .account-container {
         background-color: #383C46;
         color: white;
         padding: 8px 16px;
         border-radius: 8px;
         display: flex;
         align-items: center;
         font-size: 16px;
         }
         .btn--success.outline {
         border: 1px solid #0d9801 !important;
         background-color: transparent !important;
         color: #0d9801!important;
         }
         .btn {
         color: white!important;
         font-weight: 500;
         padding: 16px 29px;
         border-radius: 4px;
         z-index: 500;
         text-align: center;
         border: 1px solid transparent;
         line-height: 1;
         }
         .icon {
         width: 24px;
         height: 24px;
         background-color: #4CAF50;
         border-radius: 50%;
         display: flex;
         justify-content: center;
         align-items: center;
         margin-right: 10px;
         }
         .icon::before {
         content: '✈';
         color: white;
         font-size: 16px;
         }
         .account-info {
         display: flex;
         flex-direction: column;
         }
         .account-type {
         font-size: 10px;
         color: #B0B3B8;
         }
         .account-balance {
         font-size: 15px;
         }
         .dropdown {
         margin-left: 10px;
         cursor: pointer;
         position: relative;
         }
         .dropdown::after {
         content: '▼';
         font-size: 10px;
         color: white;
         }
         .dropdown-menu {
         display: none;
         position: absolute;
         top: 100%;
         left: 0;
         background-color: #383C46;
         padding: 5px 0;
         border-radius: 4px;
         box-shadow: 0 4px 8px rgba(0, 0, 0, 0.2);
         }
         .dropdown-menu a {
         display: block;
         padding: 5px 20px;
         color: white;
         text-decoration: none;
         }
         .dropdown-menu a:hover {
         background-color: #4CAF50;
         }
         .dropdown:hover .dropdown-menu {
         display: block;
         }
         @media (max-width: 576px) {
         .has-mega-menu .mega-menu {
         width: 350px !important;
         }
         }
         @media (min-width: 576px) and (max-width: 768px) {
         has-mega-menu .mega-menu {
         width: 350px !important;
         }
         }

         .toggleModeBtn.live-mode {
            background-color: red !important;
         }

         .toggleModeBtn.demo-mode {
            background-color: green !important;
         }

      </style>
      <header class="header" id="header">
         <div class="container">
            <nav class="navbar navbar-expand-lg navbar-light">
               <a class="navbar-brand logo" href="dashboard">
               <img src="assets/images/logoIcon/logo.png">
               </a>
               <button class="navbar-toggler header-button" type="button" data-bs-toggle="collapse" data-bs-target="#navbarSupportedContent" aria-controls="navbarSupportedContent" aria-expanded="false" aria-label="Toggle navigation">
               <span id="hiddenNav"><i class="fas fa-bars"></i></span>
               </button>
               <div class="collapse navbar-collapse" id="navbarSupportedContent">
                  <ul class="navbar-nav nav-menu me-auto align-items-lg-center flex-wrap">
                     <li class="nav-item d-block d-lg-none">
                        <div class="top-button d-flex flex-wrap justify-content-between align-items-center">
                           <ul class="login-registration-list d-flex flex-wrap align-items-center">
                              <li class="login-registration-list__item">
                                 <button class="btn btn--base btn--sm toggleModeBtn demo-mode"><?= $buttonLabel ?></button>
                              </li>
                              <li class="nav-item has-mega-menu">
                                 <a class="nav-link" href="javascript:void(0)">
                                    <div class="account-container">
                                       <div class="icon"></div>
                                       <div class="account-info">
                                          <div class="account-type">DEMO ACCOUNT (M)</div>
                                          <div class="account-balance demo-bal">$9,767</div>
                                       </div>
                                       <div class="dropdown"></div>
                                    </div>
                                 </a>
                                 <div class="mega-menu">
                                    <div class="mega-menu__inner">
                                       <ul class="mega-menu-list" style="padding-left: 0px!important;">
                                          <li class="mega-menu-list__item mega-item-bg1">
                                             <div class="mega-menu-list__link">
                                                <div class="mega-menu-list__content">
                                                   <div class="d-flex justify-content-between" style="align-items: center;">
                                                      <div>
                                                         <span class="mega-menu-list__title"><?=ucfirst($firstname).' '.ucfirst($lastname)?></span> <br>
                                                         <!-- <small class="equity-info">0--USD<span class="green"></span></small> -->
                                                      </div>
                                                      <div>
                                                         <span class="mega-menu-list__title">
                                                            <div class="live-banner">LIVE ACCOUNT</div>
                                                         </span>
                                                      </div>
                                                   </div>
                                                   <a type="button" href="dashboard" class="btn btn--success outline flex-fill btn--sm">  Top Up</a>
                                                   <hr>
                                                   <div class="equity-info">
                                                      <div>
                                                         <span class="text--base fs-12">BALANCE</span>
                                                         <p class="trading-header-number">
                                                            <span class="market-price-3 ">$<?php echo number_format($total_balance,2) ?></span>
                                                         </p>
                                                      </div>
                                                      <div>
                                                         <span class="text--base fs-12">CREDIT</span>
                                                         <p class="trading-header-number">
                                                            <span class="market-price-3 ">250.00</span>
                                                         </p>
                                                      </div>
                                                      <div>
                                                         <span class="text--base fs-12">EQUITY</span>
                                                         <p class="trading-header-number">
                                                            <span class="market-price-3 ">234.00</span>
                                                         </p>
                                                      </div>
                                                      <div>
                                                         <span class="text--base fs-12">FREE MARGIN</span>
                                                         <p class="trading-header-number">
                                                            <span class="market-price-3 ">32.00</span>
                                                         </p>
                                                      </div>
                                                   </div>
                                                </div>
                                             </div>
                                          </li>
                                          <li class="mega-menu-list__item mega-item-bg2">
                                             <div class="mega-menu-list__link" style="position: relative;">
                                                <div class="mega-menu-list__content">
                                                   <div class="d-flex justify-content-between" style="align-items: center;">
                                                      <div>
                                                         <div class="d-flex justify-content-between">
                                                            <span class="mega-menu-list__title">
                                                               <div class="demo-banner">DEMO ACCOUNT</div>
                                                            </span>
                                                         </div>
                                                         <br> 
                                                      </div>
                                                      <div>
                                                      </div>
                                                   </div>
                                                   <hr>
                                                   <div class="equity-info">
                                                      <div>
                                                         <span class="text--base fs-12">BALANCE</span>
                                                         <p class="trading-header-number">
                                                            <span class="market-price-3 demo-bal">$9,767</span>
                                                         </p>
                                                      </div>
                                                      <div>
                                                         <span class="text--base fs-12">CREDIT</span>
                                                         <p class="trading-header-number">
                                                            <span class="market-price-3">78.00</span>
                                                         </p>
                                                      </div>
                                                      <div>
                                                         <span class="text--base fs-12">EQUITY</span>
                                                         <p class="trading-header-number">
                                                            <span class="market-price-3">235.00</span>
                                                         </p>
                                                      </div>
                                                      <div>
                                                         <span class="text--base fs-12">FREE MARGIN</span>
                                                         <p class="trading-header-number">
                                                            <span class="market-price-3">200.00</span>
                                                         </p>
                                                      </div>
                                                   </div>
                                                </div>
                                             </div>
                                          </li>
                                       </ul>
                                    </div>
                                 </div>
                              </li>
                              <li class="login-registration-list__item">
                                 <a href="dashboard" class="btn btn--base btn--sm">Dashboard</a>
                              </li>
                              <li class="login-registration-list__item">
                                 <a href="logout" class="sign-in">Logout</a>
                              </li>
                           </ul>
                        </div>
                     </li>
                     <!--<li class="nav-item">-->
                     <!--    <a class="nav-link" href="transactions">Transction History</a>-->
                     <!--</li>-->
                     <li class="nav-item">
                        <a class="nav-link" href="trader">Copy Trading</a>
                     </li>
                     <!--<li class="nav-item">-->
                     <!--    <a class="nav-link" href="order/open">Manage Order</a>-->
                     <!--</li>-->
                     <!-- <li class="nav-item">-->
                     <!--    <a class="nav-link" href="settings">Security</a>-->
                     <!--</li>-->
                  </ul>
               </div>
               <ul class="header-right d-lg-block d-none">
                  <li class="nav-item">
                     <div class="top-button d-flex flex-wrap justify-content-between align-items-center">
                        <ul class="login-registration-list d-flex flex-wrap align-items-center">
                           <li class="login-registration-list__item">
                                 <button class="btn btn--base btn--sm toggleModeBtn demo-mode"><?= $buttonLabel ?></button>

                           </li>
                           <li class="nav-item has-mega-menu">
                              <a class="nav-link" href="javascript:void(0)">
                                 <div class="account-container">
                                    <div class="icon"></div>
                                    <div class="account-info">
                                       <div class="account-type">DEMO ACCOUNT</div>
                                       <div class="account-balance demo-bal">$9,767</div>
                                    </div>
                                    <div class="dropdown"></div>
                                 </div>
                              </a>
                              <div class="mega-menu open">
                                 <div class="mega-menu__inner">
                                    <ul class="mega-menu-list" style="padding-left: 0px!important;">
                                       <li class="mega-menu-list__item mega-item-bg1">
                                          <div class="mega-menu-list__link">
                                             <div class="mega-menu-list__content">
                                                <div class="d-flex justify-content-between" style="align-items: center;">
                                                   <div>
                                                      <span class="mega-menu-list__title"><?=ucfirst($firstname).' '.ucfirst($lastname)?></span> <br>
                                                      <!-- <small class="equity-info">0--USD<span class="green"></span></small> -->
                                                   </div>
                                                   <div>
                                                      <span class="mega-menu-list__title">
                                                         <div class="live-banner">LIVE ACCOUNT</div>
                                                      </span>
                                                   </div>
                                                   
                                                </div>
                                                <a id="topUpBtn" type="button" href="demo/add-balance" class="btn btn--success outline flex-fill btn--sm">Top Up</a>
                                                <hr>
                                                <div class="equity-info">
                                                   <div>
                                                      <span class="text--base fs-12">BALANCE</span>
                                                      <p class="trading-header-number">
                                                         <span class="market-price-3 ">$<?php echo number_format($total_balance,2) ?></span>
                                                      </p>
                                                   </div>
                                                   <div>
                                                      <span class="text--base fs-12">CREDIT</span>
                                                      <p class="trading-header-number">
                                                         <span class="market-price-3 ">250.00</span>
                                                      </p>
                                                   </div>
                                                   <div>
                                                      <span class="text--base fs-12">EQUITY</span>
                                                      <p class="trading-header-number">
                                                         <span class="market-price-3 ">234.00</span>
                                                      </p>
                                                   </div>
                                                   <div>
                                                      <span class="text--base fs-12">FREE MARGIN</span>
                                                      <p class="trading-header-number">
                                                         <span class="market-price-3 ">32.00</span>
                                                      </p>
                                                   </div>
                                                </div>
                                             </div>
                                          </div>
                                       </li>
                                       <li class="mega-menu-list__item mega-item-bg2">
                                          <div class="mega-menu-list__link" style="position: relative;">
                                             <div class="mega-menu-list__content">
                                                <div class="d-flex justify-content-between" style="align-items: center;">
                                                   <div>
                                                      <div class="d-flex justify-content-between">
                                                         <span class="mega-menu-list__title">
                                                            <div class="demo-banner">DEMO ACCOUNT</div>
                                                         </span>
                                                      </div>
                                                      <br>
                                                      
                                                   </div>
                                                   <div></div>
                                                </div>
                                                <hr>
                                                <div class="equity-info">
                                                   <div>
                                                      <span class="text--base fs-12">BALANCE</span>
                                                      <p class="trading-header-number">
                                                         <span class="market-price-3 demo-bal">$9,767</span>
                                                      </p>
                                                   </div>
                                                   <div>
                                                      <span class="text--base fs-12">CREDIT</span>
                                                      <p class="trading-header-number">
                                                         <span class="market-price-3">78.00</span>
                                                      </p>
                                                   </div>
                                                   <div>
                                                      <span class="text--base fs-12">EQUITY</span>
                                                      <p class="trading-header-number">
                                                         <span class="market-price-3">235.00</span>
                                                      </p>
                                                   </div>
                                                   <div>
                                                      <span class="text--base fs-12">FREE MARGIN</span>
                                                      <p class="trading-header-number">
                                                         <span class="market-price-3">200.00</span>
                                                      </p>
                                                   </div>
                                                </div>
                                             </div>
                                          </div>
                                       </li>
                                       <script type="text/javascript">
                                          document.getElementById('topUpBtn').addEventListener('click', function(event) {
                                               event.stopPropagation();
                                               window.location.href = this.getAttribute('href');
                                           });
                                          
                                          
                                       </script>
                                    </ul>
                                 </div>
                              </div>
                           </li>
                           <li class="login-registration-list__item">
                              <a href="dashboard" class="btn btn--base btn--sm">Dashboard</a>
                           </li>
                           <li class="login-registration-list__item">
                              <a href="logout" class="sign-in">Logout</a>
                           </li>
                        </ul>
                     </div>
                  </li>
               </ul>
            </nav>
         </div>
      </header>
      <script src="https://cdn.jsdelivr.net/npm/chart.js" type="text/javascript"></script>
      <style>
         #chart {
         width: 100%;
         height: 85vh;
         }
         .countdown {
         color: #FFF;
         background-color: transparent;
         background-image: none;
         border: 1px solid #FFF;
         font-size: 10px;
         font-weight: 400;
         text-align: center;
         padding: .275rem .45rem;
         border-radius: .25rem;
         }
         .iconi {
         width: 70px;
         height: 70px;
         background-color: #f9f9f91c;
         border-radius: 50%;
         display: flex;
         justify-content: center;
         align-items: center;
         margin: 0 auto 20px;
         background-image: url('assets/images/stocks/empty-box.png');
         background-size: 29px 29px;
         background-position: center;
         background-repeat: no-repeat;
         }
         .form--control {
         padding: 13px!important;
         }
         .message {
         max-width: 300px;
         }
         .alert {
         font-size: .70rem!important;
         }
         @media (max-width: 767px) {
         .row>* {
         padding-right: 0px!important;
         padding-left: 0px!important;
         }
         .btn {
         padding: 10px 25px!important;
         }
         .btn {
         border-radius: 4px;
         border: none;
         font-size: 16px;
         line-height: 20px;
         display: inline-flex;
         -webkit-box-align: center;
         font-weight: 700;
         text-decoration: none;
         }
         .trading-list-empty {
         height: 55vh;
         padding: 8px 30px;
         overflow: auto;
         }
         .trading-list-empt {
         height: 55vh;
         padding: 8px 30px;
         overflow: auto;
         }
         }
         .form--control {
         color: hsl(0deg 0% 100%)!important;
         }
         .form--control {
         border-color: white!important;
         }
         @media (min-width: 992px) {
         #chart {
         width: 80%;
         }
         .trading-list-empty {
         height: 40vh;
         padding: 8px 15px;
         overflow: auto;
         }
         .trading-list-empt {
         height: 50vh;
         padding: 8px 15px;
         overflow: auto;
         }
         .btn {
         border-radius: 4px;
         border: none;
         font-size: 16px;
         line-height: 20px;
         display: inline-flex;
         padding: 12px 45px;
         -webkit-box-align: center;
         font-weight: 700;
         text-decoration: none;
         }
         }
         .contain {
         display: flex;
         margin-top: 2rem!important;
         flex-direction: column;
         align-items: center;
         }
         .trade-item {
         align-items: center;
         padding: 5px 0;
         font-size: 11px;
         color: white!important;
         border-bottom: 1px solid #444;
         }
         .trade-item:last-child {
         border-bottom: none;
         }
         .trade-icon {
         margin-right: 10px;
         }
         .trade-icon img {
         width: 24px;
         height: 24px;
         }
         .trade-details {
         margin-right: 20px;
         }
         .trade-result {
         align-items: left;
         }
         .trade-profit {
         color: #00ff00;
         }
         .trade-loss {
         color: #ff0000;
         }
         /* Add this CSS for the spinner */
         .spinner-border {
         width: 1rem;
         height: 1rem;
         border-width: .2em;
         }
         .spinner-box {
         display: flex;
         align-items: center;
         justify-content: center;
         padding: 1rem;
         }
         td {
         padding-bottom: 1rem!important;
         }
      </style>
      <div class="bg-color" style="padding-top: 3rem; padding-bottom: 12rem; padding-left: 2.1rem;">
         <div class="container custom--container" style="max-width: 97%!important; align-self: stretch;">
            <div class="row col-12" style="padding: 0px;">
               <div class="trading-left col-lg-10" id="chart">
                  <div style="width: 100%; height: 100%;">
                     <style>
                        .tradingview-widget-copyright {
                        font-size: 13px !important;
                        line-height: 32px !important;
                        text-align: center !important;
                        vertical-align: middle !important;
                        /* @mixin sf-pro-display-font; */
                        font-family: -apple-system, BlinkMacSystemFont, 'Trebuchet MS', Roboto, Ubuntu, sans-serif !important;
                        color: #B2B5BE !important;
                        }
                        .tradingview-widget-copyright .blue-text {
                        color: #2962FF !important;
                        }
                        .tradingview-widget-copyright a {
                        text-decoration: none !important;
                        color: #B2B5BE !important;
                        }
                        .tradingview-widget-copyright a:visited {
                        color: #B2B5BE !important;
                        }
                        .tradingview-widget-copyright a:hover .blue-text {
                        color: #1E53E5 !important;
                        }
                        .tradingview-widget-copyright a:active .blue-text {
                        color: #1848CC !important;
                        }
                        .tradingview-widget-copyright a:visited .blue-text {
                        color: #2962FF !important;
                        }
                     </style>
                     <iframe scrolling="no" allowtransparency="true" frameborder="0" src="https://www.tradingview-widget.com/embed-widget/advanced-chart/?locale=en#%7B%22autosize%22%3Atrue%2C%22symbol%22%3A%22NASDAQ%3AMSFT%22%2C%22interval%22%3A%221%22%2C%22timezone%22%3A%22Etc%2FUTC%22%2C%22theme%22%3A%22dark%22%2C%22style%22%3A%221%22%2C%22backgroundColor%22%3A%22rgba(36%2C%2039%2C%2049%2C%201)%22%2C%22gridColor%22%3A%22rgba(238%2C%20238%2C%20238%2C%200.07)%22%2C%22hide_top_toolbar%22%3Atrue%2C%22allow_symbol_change%22%3Atrue%2C%22save_image%22%3Afalse%2C%22calendar%22%3Afalse%2C%22support_host%22%3A%22https%3A%2F%2Fwww.tradingview.com%22%2C%22width%22%3A%22100%25%22%2C%22height%22%3A%22100%25%22%2C%22utm_source%22%3A%22expcopytrading.com%22%2C%22utm_medium%22%3A%22widget%22%2C%22utm_campaign%22%3A%22advanced-chart%22%2C%22page-uri%22%3A%22expcopytrading.com%2Fapp%2Fuser%2Ftrade%22%7D" title="advanced chart TradingView widget" lang="en" style="user-select: none; box-sizing: border-box; display: block; height: 100%; width: 100%;"></iframe>
                  </div>
               </div>
               <div class="col-lg-2 align-right">
                  <div id="message-box" class="mt-1 mb-1"></div>
                  <div class="trading-left trading-list-empt">
                    <div class="trade-info">
                      <div class="form-group" style="margin-bottom: .5rem!important;">
                        <div class="d-flex justify-content-between p-2 mb-2">
                          <label class="form-label">Stock</label>
                          <label class="text-end">81%</label>
                        </div>
                        <select style="background-color:#242731" class="form--control form-control" name="stock" id="stock" required="">
                          <option value="" selected="" disabled="">Choose Stock...</option>
                          <option value="AAPL" data-image="assets/images/stocks/aapl.png">Apple (AAPL)</option>
                          <option value="MSFT" data-image="assets/images/stocks/microsoft.png">Microsoft (MSFT)</option>
                          <option value="GOOGL" data-image="assets/images/stocks/googl.png">Alphabet (GOOGL)</option>
                          <option value="AMZN" data-image="assets/images/stocks/amazon.png">Amazon (AMZN)</option>
                          <option value="TSLA" data-image="assets/images/stocks/tesla.png">Tesla (TSLA)</option>
                          <option value="FB" data-image="assets/images/stocks/meta.png">Meta Platforms (FB)</option>
                          <option value="NVDA" data-image="assets/images/stocks/nvda.png">NVIDIA (NVDA)</option>
                          <option value="NFLX" data-image="assets/images/stocks/netflix.png">Netflix (NFLX)</option>
                          <option value="PYPL" data-image="assets/images/stocks/paypal.png">PayPal (PYPL)</option>
                          <option value="INTC" data-image="assets/images/stocks/intel.png">Intel (INTC)</option>
                        </select>
                      </div>
                      <div class="form-group" style="margin-bottom: .5rem!important;">
                        <label class="form-label">Time</label>
                        <select style="background-color:#242731" class="form--control form-control" name="time" id="time" required="">
                          <option value="" selected="" disabled="">Choose Time...</option>
                          <option value="5">5s</option>
                          <option value="15">15s</option>
                          <option value="30">30s</option>
                          <option value="60">1m</option>
                          <option value="300">5m</option>
                          <option value="600">10m</option>
                          <option value="1800">30m</option>
                        </select>
                      </div>
                      <div class="form-group" style="margin-bottom: 1.5rem!important;">
                        <label class="form-label">Amount</label>
                        <div class="input-group">
                          <input type="number" step="any" class="form--control form-control" name="amount" id="amount" required="" autocomplete="off">
                          <span class="input-group-text text-white deposit-currency-symbol">USD</span>
                        </div>
                      </div>
                      <div class="form-group text-center form-button">
                        <button class="btn btn--success btn--lg" id="btn-up">
                          <i class="fa fa-arrow-up"></i> &nbsp; Up &nbsp;
                        </button>
                        <p id="payout" class="p-2" style="color: white!important;">Your Payout 0 USD</p>
                        <button class="btn btn--danger btn-lg" id="btn-down">
                          <i class="fa fa-arrow-down"></i> &nbsp;Down
                        </button>
                      </div>
                    </div>
                  </div>
                  <br>
                  <div class="trading-left trading-list-empty">
                    <div class="trade-info mb-1">
                      <p>Trades History</p>
                    </div> 
                    <div class="trade-item"  style="font:12px" id="trade-history">
                      <!-- Trade history will be dynamically populated here -->
                    </div>
                  </div>
                </div>
               </div>
            </div>
         </div>
      </div>
      <script>
         document.querySelectorAll('.toggleModeBtn').forEach(button => {
         button.addEventListener('click', function () {
            fetch('api.php?action=switch', {
               method: 'POST'
            })
            .then(response => response.json())
            .then(data => {
               if (data.status === 'success') {
               const isLive = data.new_mode === 'live';

               document.querySelectorAll('.toggleModeBtn').forEach(btn => {
                  btn.textContent = isLive ? 'Switch To Demo' : 'Switch To Live';
                  btn.classList.toggle('live-mode', isLive);
                  btn.classList.toggle('demo-mode', !isLive);
               });
               }
            });
         });
         });
      </script>



      <script type="text/javascript">
         
         document.addEventListener('DOMContentLoaded', function() {
          const amountInput = document.getElementById('amount');
          const btnUp = document.getElementById('btn-up');
          const btnDown = document.getElementById('btn-down');
          const stockSelect = document.getElementById('stock');
          const messageBox = document.getElementById('message-box');
        
          amountInput.addEventListener('input', calculatePayout);
          btnUp.addEventListener('click', (event) => handleTrade('buy', event));
          btnDown.addEventListener('click', (event) => handleTrade('sell', event));
          stockSelect.addEventListener('change', initializeTradingViewChart);
        
          function calculatePayout() {
            const amount = parseFloat(amountInput.value);
            const profitPercentage = 81;
            const payout = amount ? (amount + (profitPercentage / 100) * amount).toFixed(2) : 0;
            document.getElementById('payout').innerText = `Your Payout ${payout} USD`;
          }
        
          function handleTrade(action, event) {
            event.preventDefault();
            const button = event.target.closest('button');
            const stock = stockSelect.value;
            const amount = amountInput.value;
            const time = document.getElementById('time').value;
            const originalButtonText = button.innerHTML;
        
            if (!stock || !amount || !time) {
              showMessage('Please select a stock, enter an amount, and choose a time.', 'danger');
              return;
            }
        
            button.innerHTML = '<div class="spinner-border spinner-border-sm text-light" role="status"></div>';
        
            fetch(`api.php?action=${action}`, {
              method: 'POST',
              headers: {
                'Content-Type': 'application/json',
                'X-CSRF-TOKEN': 'xrir56d07i6w4qiwr8PMfIPeXZZSklIZeSAmE0Xv'
              },
              body: JSON.stringify({
                stock: stock,
                amount: amount,
                time: time,
                trade_side: action === 'buy' ? 1 : 2
              })
            })
            .then(response => response.json())
            .then(data => {
              button.innerHTML = originalButtonText;
              if (data.status_code === 200) {
                showMessage(data.message, 'success');
                updateTradeHistory();
                updateAccountBalance();
                resetForm();
              } else {
                showMessage(data.message, 'danger');
              }
            })
            .catch(error => {
              console.error('Error:', error);
              button.innerHTML = originalButtonText;
              showMessage('An error occurred. Please try again.', 'danger');
            });
          }
        
          function showMessage(message, type) {
            messageBox.innerHTML = `<div class="alert alert-${type}">${message}</div>`;
            setTimeout(() => messageBox.innerHTML = '', 3000);
          }
        
          function updateAccountBalance() {
            fetch("api.php?action=balance")
              .then(response => response.json())
              .then(data => {
                document.querySelectorAll('.demo-bal').forEach(element => {
                  element.textContent = `$${Number(data.balance).toLocaleString('en-US')}`;
                });
              })
              .catch(error => console.error('Error fetching account balance:', error));
          }
        
          function updateTradeHistory() {
            fetch("api.php?action=trade-list")
              .then(response => response.json())
              .then(data => {
                const tradeHistoryContainer = document.getElementById('trade-history');
                tradeHistoryContainer.innerHTML = data.length ? '' : `
                  <div class="contain">
                    <div class="iconi"></div>
                    <div class="message">You don't have a trade history yet. You can open a trade using the form above.</div>
                  </div>`;
        
                data.forEach(trade => {
                  const tradeElement = createTradeElement(trade);
                  tradeHistoryContainer.insertAdjacentHTML('beforeend', tradeElement);
                  if (trade.time > 0) startCountdown(trade);
                });
              })
              .catch(error => console.error('Error fetching trade history:', error));
          }
        
          function createTradeElement(trade) {
            return `
              <table width="100%;">
                <tbody>
                  <tr class="trade-info mb-3">
                    <td class="trade-icon">
                      <img src="assets/images/stocks/${trade.image}" style="border-radius: 50%; background-color: white;" alt="icon">
                      <span class="account-type">&nbsp; ${trade.symbol}</span>
                    </td>
                    <td class="align-left">
                      <span style="color: ${trade.trade_side == 1 ? 'green' : 'red'};">
                        <i class="fa fa-arrow-${trade.trade_side == 1 ? 'up' : 'down'}"></i>
                      </span>
                    </td>
                    <td class="align-left">
                      <span class="account-type">$${trade.amount}</span>
                    </td>
                    <td class="trade-result account-type" id="trade-result-${trade.id}">
                      <span class="countdown" id="countdown-${trade.id}">
                        <span class="spinner-border spinner-border-sm"></span>
                      </span>
                    </td>
                  </tr>
                </tbody>
              </table>`;
          }
        
          function startCountdown(trade) {
            let countdown = trade.time;
            const countdownElement = document.getElementById(`countdown-${trade.id}`);
            const interval = setInterval(() => {
              countdown -= 1;
              updateTradeTime(trade.id);
              
              const minutes = String(Math.floor(countdown / 60)).padStart(2, '0');
              const seconds = String(countdown % 60).padStart(2, '0');
              countdownElement.textContent = `${minutes}:${seconds}`;
        
              if (countdown <= 0) {
                clearInterval(interval);
                updateTradeResult(trade);
              }
            }, 1000);
          }
        
          function updateTradeTime(tradeId) {
            fetch(`api.php?action=deduct-time&id=${tradeId}`, {
              method: 'GET',
              headers: {
                'Content-Type': 'application/json',
                'X-CSRF-TOKEN': 'xrir56d07i6w4qiwr8PMfIPeXZZSklIZeSAmE0Xv'
              }
            })
            .then(response => response.json())
            .catch(error => console.error('Error updating trade time:', error));
          }
        
          function updateTradeResult(trade) {
            const tradeResultContainer = document.getElementById(`trade-result-${trade.id}`);
            tradeResultContainer.innerHTML = trade.type == 1 ? 
              `<span class="trade-profit">+$${trade.profit}</span>` : 
              `<span class="trade-loss">-$${trade.amount}</span>`;
          }
        
          function resetForm() {
            amountInput.value = '';
            stockSelect.value = '';
            document.getElementById('time').value = '';
            calculatePayout();
          }
        
          function initializeTradingViewChart() {
            const selectedStock = this.value;
            const widget = document.getElementById('chart');
        
            widget.innerHTML = '';
        
            if (selectedStock) {
              const script = document.createElement('script');
              script.type = 'text/javascript';
              script.src = 'https://s3.tradingview.com/external-embedding/embed-widget-advanced-chart.js';
              script.async = true;
              script.innerHTML = JSON.stringify({
                autosize: true,
                symbol: "NASDAQ:" + selectedStock,
                interval: "1",
                timezone: "Etc/UTC",
                theme: "dark",
                style: "1",
                locale: "en",
                backgroundColor: "rgba(36, 39, 49, 1)",
                gridColor: "rgba(238, 238, 238, 0.07)",
                hide_top_toolbar: true,
                allow_symbol_change: true,
                save_image: false,
                calendar: false,
                support_host: "https://www.tradingview.com"
              });
        
              widget.appendChild(script);
            }
          }
        
          // Initial calls
          calculatePayout();
          updateTradeHistory();
          updateAccountBalance();
        });
      </script>
      <script>(function(){function c(){var b=a.contentDocument||a.contentWindow.document;if(b){var d=b.createElement('script');d.innerHTML="window.__CF$cv$params={r:'8e272db529e0bd86',t:'MTczMTU4OTE2NS4wMDAwMDA='};var a=document.createElement('script');a.nonce='';a.src='/cdn-cgi/challenge-platform/scripts/jsd/main.js';document.getElementsByTagName('head')[0].appendChild(a);";b.getElementsByTagName('head')[0].appendChild(d)}}if(document.body){var a=document.createElement('iframe');a.height=1;a.width=1;a.style.position='absolute';a.style.top=0;a.style.left=0;a.style.border='none';a.style.visibility='hidden';document.body.appendChild(a);if('loading'!==document.readyState)c();else if(window.addEventListener)document.addEventListener('DOMContentLoaded',c);else{var e=document.onreadystatechange||function(){};document.onreadystatechange=function(b){e(b);'loading'!==document.readyState&&(document.onreadystatechange=e,c())}}}})();</script><iframe height="1" width="1" style="position: absolute; top: 0px; left: 0px; border: none; visibility: hidden;"></iframe><script defer="" src="https://static.cloudflareinsights.com/beacon.min.js/vcd15cbe7772f49c399c6a5babf22c1241717689176015" integrity="sha512-ZpsOmlRQV6y907TI0dKBHq9Md29nnaEIPlkf84rnaERnq6zvWvPUqr2ft8M1aS28oN72PdrCzSjY4U6VaAw1EQ==" data-cf-beacon="{&quot;rayId&quot;:&quot;8e272db529e0bd86&quot;,&quot;version&quot;:&quot;2024.10.5&quot;,&quot;r&quot;:1,&quot;token&quot;:&quot;e88c02f5f4904215bf000c76be9e9160&quot;,&quot;serverTiming&quot;:{&quot;name&quot;:{&quot;cfExtPri&quot;:true,&quot;cfL4&quot;:true,&quot;cfSpeedBrain&quot;:true,&quot;cfCacheStatus&quot;:true}}}" crossorigin="anonymous"></script>
      <footer class="footer-area">
         <div class="bottom-footer">
            <div class="container">
               <div class="bottom-footer__style py-3">
                  <div class="gap-4 d-flex flex-wrap justify-content-between align-items-center">
                     <div class="bottom-footer__text">
                        © 2024 <a href="/" class="text--base"> <?php echo $sitename; ?>
                        </a>. All Rights Reserved                    
                     </div>
                  </div>
               </div>
            </div>
         </div>
      </footer>

      <script src="assets/global/js/jquery-3.7.1.min.js" type="text/javascript"></script>
      <script src="assets/global/js/bootstrap.bundle.min.js" type="text/javascript"></script>
      <script src="assets/templates/basic/js/main.js" type="text/javascript"></script>
      <script type="text/javascript">
         window.my_pusher = {
             'app_key': "",
             'app_cluster': "",
             'base_url': "<?php echo $siteurl ?>"
         }
         window.allow_decimal = "4";
      </script>
      <script src="https://code.jquery.com/jquery-3.2.1.slim.min.js" integrity="sha384-KJ3o2DKtIkvYIK3UENzmM7KCkRr/rE9/Qpg6aAZGJwFDMVNA/GpGFF93hXpG5KkN" crossorigin="anonymous" type="text/javascript"></script>
      <link href="assets/global/css/iziToast.min.css" rel="stylesheet">
      <link href="assets/global/css/iziToast_custom.css" rel="stylesheet">
      <script src="assets/global/js/iziToast.min.js" type="text/javascript"></script>
      <script type="text/javascript">
         "use strict";
         const colors = {
             success: '#28c76f',
             error: '#eb2222',
             warning: '#ff9f43',
             info: '#1e9ff2',
         }
         
         const icons = {
             success: 'fas fa-check-circle',
             error: 'fas fa-times-circle',
             warning: 'fas fa-exclamation-triangle',
             info: 'fas fa-exclamation-circle',
         }
         
         const notifications = [];
         const errors = [];
         
         
         const triggerToaster = (status, message) => {
             iziToast[status]({
                 title: status.charAt(0).toUpperCase() + status.slice(1),
                 message: message,
                 position: "topRight",
                 backgroundColor: '#fff',
                 icon: icons[status],
                 iconColor: colors[status],
                 progressBarColor: colors[status],
                 titleSize: '1rem',
                 messageSize: '1rem',
                 titleColor: '#474747',
                 messageColor: '#a2a2a2',
                 transitionIn: 'obunceInLeft'
             });
         }
         
         if (notifications.length) {
             notifications.forEach(element => {
                 triggerToaster(element[0], element[1]);
             });
         }
         
         if (errors.length) {
             errors.forEach(error => {
                 triggerToaster('error', error);
             });
         }
         
         function notify(status, message) {
             if (typeof message == 'string') {
                 triggerToaster(status, message);
             } else {
                 $.each(message, (i, val) => triggerToaster(status, val));
             }
         }
      </script>
      <script type="text/javascript">
         (function($) {
             "use strict";
         
             $('.change-lang').on('click', function(e) {
                 let langCode = $(this).data('code');
                 window.location.href = "change/" + langCode;
             });
         
             
                 window.matchMedia('(prefers-color-scheme: dark)').addEventListener('change', event => {
                     let windowsIsDarkTheme = window.matchMedia('(prefers-color-scheme: dark)').matches;
                     if (windowsIsDarkTheme) {
                         setTheme('light');
                     } else {
                         setTheme('dark');
                     }
                 });
         
                 const toggleSwitch = document.querySelector('.theme-switch input[type="checkbox"]');
                 const currentTheme = localStorage.getItem('theme');
         
                 if (currentTheme) {
                     setTheme(currentTheme);
                 } else {
                     let defaultTheme = `light`;
         
                     if (defaultTheme == 'dark') {
                         setTheme('dark');
                     } else {
                         setTheme('light');
                     }
                 }
         
                 function setTheme(theme) {
                     document.documentElement.setAttribute('data-theme', theme);
                     localStorage.setItem('theme', theme);
                     theme == 'dark' ? toggleSwitch.checked = true : toggleSwitch.checked = false;
                 }
         
                 toggleSwitch.addEventListener('change', function(e) {
                     setTheme(e.target.checked ? 'dark' : 'light');
                 });
             
             var inputElements = $('input,select');
             $.each(inputElements, function(index, element) {
                 element = $(element);
                 element.closest('.form-group').find('label').attr('for', element.attr('name'));
                 element.attr('id', element.attr('name'))
             });
         
             $('.policy').on('click', function() {
                 $.get('cookie/accept', function(response) {
                     $('.cookies-card').addClass('d-none');
                 });
             });
         
             setTimeout(function() {
                 $('.cookies-card').removeClass('hide')
             }, 2000);
         
             var inputElements = $('[type=text],select,textarea');
             $.each(inputElements, function(index, element) {
                 element = $(element);
                 element.closest('.form-group').find('label').attr('for', element.attr('name'));
                 element.attr('id', element.attr('name'))
             });
         
             $.each($('input, select, textarea'), function(i, element) {
                 var elementType = $(element);
                 if (elementType.attr('type') != 'checkbox') {
                     if (element.hasAttribute('required')) {
                         $(element).closest('.form-group').find('label').addClass('required');
                     }
                 }
             });
         
         })(jQuery);
         
         
         async function registerSW() {
             if ('serviceWorker' in navigator) {
                 try {
                     await navigator.serviceWorker.register("assets/templates/basic/js/pwa/serviceworker.js");
                 } catch (e) {
                     console.warn('SW registration failed');
                 }
             }
         }
         window.addEventListener('load', () => {
             registerSW();
         });
      </script>
      <script src="https://cdnjs.cloudflare.com/ajax/libs/intro.js/7.2.0/intro.min.js" type="text/javascript"></script>
      <script src="https://cdn.jsdelivr.net/npm/popper.js@1.12.9/dist/umd/popper.min.js" integrity="sha384-ApNbgh9B+Y1QKtv3Rn7W3mgPxhU9K/ScQsAP7hUibX39j7fakFPskvXusvfa0b4Q" crossorigin="anonymous" type="text/javascript"></script>
      <script src="https://cdn.jsdelivr.net/npm/bootstrap@4.0.0/dist/js/bootstrap.min.js" integrity="sha384-JZR6Spejh4U02d8jOt6vLEHfe/JQGiRRSQQxSfFWpi1MquVdAyjUar5+76PVCmYl" crossorigin="anonymous" type="text/javascript"></script>
      <iframe id="chat-application-iframe" title="Smartsupp" aria-hidden="true" style="display: block; position: fixed; top: 0px; left: 0px; width: 1px; height: 1px; opacity: 0; border: none; z-index: -1; pointer-events: none;"></iframe>
      <div id="smartsupp-widget-container">
         <div style="border-radius: 9999px; box-shadow: rgba(0, 0, 0, 0.06) 0px 1px 6px, rgba(0, 0, 0, 0.12) 0px 2px 32px; color-scheme: normal; height: 56px; position: fixed; bottom: 24px; left: initial; right: 12px; z-index: 10000000; width: 109px;" data-testid="widgetButtonFrame"><iframe id="widgetButtonFrame" title="Smartsupp widget button" style="position: absolute; width: 100%; height: 100%; border: none; display: block; text-align: left; margin: 0px; padding: 0px; top: 0px; left: 0px; opacity: 1;" allowfullscreen="" scrolling="no"></iframe></div>
      </div>
   </body>
</html>